<?php
/**
 * The template for displaying related posts by tags
 *
 * @package WordPress
 * @subpackage Orin
 * @since Orin 1.0
 */

// show or hide related posts
$show_related_posts = get_theme_mod( 'orin_single_show_related_posts', 0 ); // 1 or 0
if ( $show_related_posts ) {

	// current post ID
	$current_post_id = $post->ID;

	// get tags for current post
	$current_post_tags = wp_get_post_terms( $current_post_id );
	if ( $current_post_tags ) {

		// get tags IDs
		$current_post_tags_count = count( $current_post_tags );
		for ( $i = 0; $i < $current_post_tags_count; $i++ ) {
			$current_post_tag_IDs[ $i ] = $current_post_tags[ $i ]->term_id;
		}

		// query arguments
		$related_posts_args = array(
			'tag__in'				=> $current_post_tag_IDs,
			'post__not_in'			=> array( $current_post_id ),
			'posts_per_page'		=> 3,
			'orderby'				=> 'rand',
			'ignore_sticky_posts'	=> true,
		);

		// start query
		$related_posts = new WP_Query( $related_posts_args );
		if ( $related_posts->have_posts() ) :
			?>

			<!-- related posts (by tags) -->
			<div class="bwp-related-posts">
				<div class="bwp-related-posts-wrap">
					<div class="bwp-separator bwp-gradient"><span class="bwp-rhomb"></span></div>
					<h2 class="bwp-related-posts-title"><?php esc_html_e( 'You may also like', 'orin' ); ?></h2>
					<div class="bwp-related-posts-list clearfix">

						<?php
						while ( $related_posts->have_posts() ) :
							$related_posts->the_post();

							// post ID
							$related_post_id = $post->ID;

							// post format
							$related_post_format = get_post_format();
							if ( false === $related_post_format ) {
								$related_post_format = 'standard';
							}
							?>

							<!-- post -->
							<article id="bwp-post-<?php echo (int) $related_post_id; ?>" <?php post_class(); ?>>
								<div class="bwp-post-wrap">

									<?php
									// media (featured image / slider / video / audio)
									if ( 'gallery' === $related_post_format || 'video' === $related_post_format || 'audio' === $related_post_format ) {
										get_template_part( 'templates/blog-post-media/media', $related_post_format );
									} else {
										get_template_part( 'templates/blog-post-media/media', 'image' );
									}
									?>

									<!-- content -->
									<div class="bwp-post-content">

										<?php
										// title
										if ( get_the_title() ) {
											?>
											<!-- title -->
											<h3 class="bwp-post-title entry-title">
												<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
											</h3>
											<!-- end: title -->
											<?php
										}
										?>

										<!-- metadata (author, date, tags) -->
										<ul class="bwp-post-metadata list-unstyled">

											<?php
											// 1: author
											// author data: id, name, and author posts url
											$author_id = get_the_author_meta( 'ID' );
											$author_display_name = get_the_author_meta( 'display_name' );
											$author_posts_url = get_author_posts_url( $author_id );
											?>

											<!-- author -->
											<li class="bwp-author bwp-hidden">
												<a href="<?php echo esc_url( $author_posts_url ); ?>" rel="author">
													<span class="vcard author">
														<span class="fn"><?php echo esc_html( $author_display_name ); ?></span>
													</span>
												</a>
											</li>
											<!-- end: author -->

											<?php
											// 2: date
											// year, month, day
											$time_year = get_the_time( 'Y' );
											$time_month = get_the_time( 'm' );
											$time_day = get_the_time( 'd' );
											?>

											<!-- date -->
											<li class="bwp-date bwp-hidden">
												<a href="<?php echo esc_url( get_day_link( $time_year, $time_month, $time_day ) ); ?>">
													<span class="date updated"><?php the_time( get_option( 'date_format' ) ); ?></span>
												</a>
											</li>
											<!-- end: date -->

											<?php
											// 3: tags
											?>

											<!-- tags -->
											<li class="bwp-tags bwp-visible">
												<?php the_tags( '', ', ', '' ); ?>
											</li>
											<!-- end: tags -->

										</ul>
										<!-- end: metadata -->

									</div>
									<!-- end: content -->

								</div>
							</article>
							<!-- end: post -->

							<?php
						endwhile;
						?>

					</div>
				</div>
			</div>
			<!-- end: related posts -->

			<?php
		endif;

		// reset post data
		wp_reset_postdata();

	}

}
