<?php
/**
 * Featured image / Video player (Appears in a post on all archive pages)
 *
 * @package WordPress
 * @subpackage Orin
 * @since Orin 1.0
 */

// post ID
$blog_post_id = $post->ID;

// thumbnail type
$video_thumb_type = get_post_meta( $blog_post_id, 'orin_mb_video_thumb_type', true ); // 'iframe' or 'featured_image'
if ( ! $video_thumb_type ) {
	$video_thumb_type = 'iframe'; // default value
}

// thumbnail type = featured image
if ( 'featured_image' === $video_thumb_type ) {

	// if the post has a featured image
	if ( has_post_thumbnail() ) {

		// image data: sizes and attributes
		$image_size = 'full';
		$image_attr = '';
		if ( ! is_singular() ) {
			// archive pages; add new attributes
			$image_attr = array( 'loading' => 'eager' );
		} else {
			// single pages; new size (900x600px)
			$image_size = 'orin-900-600-crop';
		}

		// link type
		$link_type = get_theme_mod( 'orin_featured_image_link_type', 'link_to_post' ); // 'link_to_image' or 'link_to_post'
		?>

		<!-- featured image -->
		<figure class="bwp-post-media">

			<?php
			// link type: link to image
			if ( 'link_to_image' === $link_type ) {
				// image id
				$image_id = get_post_thumbnail_id();
				// data for popup image
				$popup_image_size = 'full';
				$popup_image_url = wp_get_attachment_image_url( $image_id, $popup_image_size );
				$popup_image_caption = get_post( $image_id )->post_excerpt;
				?>

				<a href="<?php echo esc_url( $popup_image_url ); ?>" class="bwp-popup-image" title="<?php if ( $popup_image_caption ) { echo esc_attr( $popup_image_caption ); } else { the_title_attribute(); } ?>">
					<?php the_post_thumbnail( $image_size, $image_attr ); ?>
					<div class="bwp-post-media-overlay"></div>
					<span class="bwp-post-hover-icon bwp-expand-image">
						<i class="fas fa-images"></i>
					</span>
					<span class="bwp-post-format-icon">
						<i class="fas fa-video"></i>
					</span>
				</a>

				<?php
			} else {
				// link type: link to post
				?>

				<a href="<?php the_permalink(); ?>">
					<?php the_post_thumbnail( $image_size, $image_attr ); ?>
					<div class="bwp-post-media-overlay"></div>
					<span class="bwp-post-hover-icon">
						<i class="fas fa-share"></i>
					</span>
					<span class="bwp-post-format-icon">
						<i class="fas fa-video"></i>
					</span>
				</a>

				<?php
			}
			?>

		</figure>
		<!-- end: featured image -->

		<?php
	}

} else { // thumbnail type = iframe

	// video URL
	$video_url = get_post_meta( $blog_post_id, 'orin_mb_video_url', true );

	// if $video_url is not empty
	if ( $video_url ) {

		// get embed code
		$video_embed_code_escaped = wp_oembed_get( esc_url( $video_url ) ); // this variable has been safely escaped

		if ( $video_embed_code_escaped ) {
			?>

			<!-- video player (iframe) -->
			<figure class="bwp-post-media bwp-video-player">
				<div class="bwp-iframe-video-wrap">
					<?php echo ! empty( $video_embed_code_escaped ) ? $video_embed_code_escaped : ''; ?>
				</div>
			</figure>
			<!-- end: video player (iframe) -->

			<?php
		}

	}

}
