<?php
/**
 * The template for displaying all pages
 *
 * @package WordPress
 * @subpackage Orin
 * @since Orin 1.0
 */

// header
get_header();

// start the loop
while ( have_posts() ) : the_post();

	// page ID
	$page_id = $post->ID;

	// page with password or not
	$is_password_protected = post_password_required();

	// this is an attachment page or not
	$is_attachment_page = is_attachment();
	?>

	<!-- main container with post -->
	<main class="bwp-single-post-container">
		<div class="bwp-separator bwp-gradient"><span class="bwp-rhomb"></span></div>

		<!-- single post (post type: page) -->
		<article id="bwp-page-<?php echo (int) $page_id; ?>" <?php post_class(); ?>>

			<!-- header -->
			<header class="bwp-single-post-header<?php if ( ! has_post_thumbnail( $page_id ) || $is_password_protected ) { echo ' bwp-no-featured-media'; } ?>">

				<?php
				// metadata (author and date)
				if ( ! $is_attachment_page ) {
					orin_show_single_post_metadata( 'page' );
				}

				// title
				if ( get_the_title() ) {
					?>
					<!-- title -->
					<h1 class="bwp-post-title entry-title"><?php the_title(); ?></h1>
					<!-- end: title -->
					<?php
				}
				?>

				<div class="bwp-single-post-header-separator"></div>
			</header>
			<!-- end: header -->

			<?php
			// featured image
			if ( ! $is_password_protected && ! $is_attachment_page ) {
				get_template_part( 'templates/single-post-media/media', 'image' );
			}
			?>

			<!-- content container -->
			<div class="bwp-single-post-content">

				<!-- content -->
				<div class="bwp-content entry-content clearfix">

					<?php
					// content
					the_content();
					?>

					<!-- clearfix -->
					<div class="clearfix"></div>

					<?php
					// pagination
					wp_link_pages( array(
						'before'			=> '<nav class="bwp-single-post-pagination clearfix"><span>' . esc_html__( 'Pages:', 'orin' ) . '</span>',
						'after'				=> '</nav>',
						'next_or_number'	=> 'number',
					) );
					?>

				</div>
				<!-- end: content -->

				<?php
				// share buttons
				if ( ! $is_password_protected ) {
					$show_share_buttons_opt = get_theme_mod( 'orin_page_show_share_buttons', 1 ); // 1 or 0
					$show_share_buttons = function_exists( 'orin_additional_features_show_share_buttons' ) && $show_share_buttons_opt;
					if ( $show_share_buttons ) {
						orin_additional_features_show_share_buttons();
					}
				}
				?>

			</div>
			<!-- end: content container -->

		</article>
		<!-- end: single post (post type: page) -->

		<?php
		// comments
		if ( comments_open() || get_comments_number() ) {
			comments_template();
		}

		// random posts
		$show_random_posts = get_theme_mod( 'orin_page_show_random_posts', 0 ); // 1 or 0
		if ( ! $is_password_protected && ! $is_attachment_page && $show_random_posts ) {
			get_template_part( 'templates/random-posts' );
		}
		?>

		<div class="bwp-separator bwp-gradient"><span class="bwp-rhomb"></span></div>
	</main>
	<!-- end: main container with post -->

	<?php
endwhile;
// end of the loop

// footer
get_footer();
