/**
 * Meta boxes with additional options (Admin side)
 * orin-meta-boxes.js v1.0
 */

( function( $ ) {
	'use strict';
	$( document ).ready( function() {

		// meta boxes for different formats
		var	$galleryBox = $( '#orin_mb_gallery_format' ), // gallery format
			$videoBox = $( '#orin_mb_video_format' ), // video format
			$audioBox = $( '#orin_mb_audio_format' ); // audio format


		/**
		 * Hide all meta boxes
		 */
		function hideAllMetaBoxes() {

			// gallery format: hide meta box
			$galleryBox.hide();
			// video format: hide meta box
			$videoBox.hide();
			// audio format: hide meta box
			$audioBox.hide();

		}

		hideAllMetaBoxes();


		/**
		 * Show/hide meta boxes for classic editor
		 */
		function showHideMetaBoxesClassic() {

			// meta box for gallery format
			if ( $( 'input#post-format-gallery' ).is( ':checked' ) ) {
				$galleryBox.show();
			} else {
				$galleryBox.hide();
			}

			// meta box for video format
			if ( $( 'input#post-format-video' ).is( ':checked' ) ) {
				$videoBox.show();
			} else {
				$videoBox.hide();
			}

			// meta box for audio format
			if ( $( 'input#post-format-audio' ).is( ':checked' ) ) {
				$audioBox.show();
			} else {
				$audioBox.hide();
			}

		}

		showHideMetaBoxesClassic();

		// classic editor: format selection
		$( '#post-formats-select input' ).on( 'click', showHideMetaBoxesClassic );

	} );
} )( jQuery );
