<?php
/**
 * Registering meta boxes
 *
 * @since Orin 1.0
 */

// add filter
add_filter( 'rwmb_meta_boxes', 'orin_register_meta_boxes' );

// function: register meta boxes
function orin_register_meta_boxes( $meta_boxes ) {

	$prefix = 'orin_mb_';

	/**
	 * Meta boxes for posts
	 * -----------------------------------------------------------------------------
	 *
	 * Additional settings
	 * -----------------------------------------------------------------------------
	 */
	$meta_boxes[] = array(
		'id'		=> "{$prefix}additional_settings",
		'title'		=> esc_html__( 'Additional Settings', 'orin' ),
		'pages'		=> array( 'post' ),
		'context'	=> 'normal',
		'priority'	=> 'high',
		'fields'	=> array(

			/**
			 * Homepage slider
			 * -----------------------------------------------------------------------------
			 */

			// Heading
			array(
				'type'	=> 'heading',
				'name'	=> esc_html__( 'Homepage slider', 'orin' ),
			),

			// Add this post to the slider on the homepage
			array(
				'name'	=> esc_html__( 'Add this post to the slider on the homepage?', 'orin' ),
				'id'	=> "{$prefix}featured_post",
				'type'	=> 'checkbox',
				'std'	=> 0,
			),

			// Image for the slider
			array(
				'name'				=> esc_html__( 'Add image for slide', 'orin' ),
				'desc'				=> esc_html__( 'This image will be displayed in the slider. If there is no image in this field, then the slider will display the Featured image of this post.', 'orin' ),
				'id'				=> "{$prefix}featured_post_image",
				'type'				=> 'image_advanced',
				'max_file_uploads'	=> 1,
			),

		),
	);


	/**
	 * Gallery format
	 * -----------------------------------------------------------------------------
	 */
	$meta_boxes[] = array(
		'id'		=> "{$prefix}gallery_format",
		'title'		=> esc_html__( 'Gallery Format Settings', 'orin' ),
		'pages'		=> array( 'post' ),
		'context'	=> 'normal',
		'priority'	=> 'high',
		'fields'	=> array(

			/**
			 * Thumbnail type (or media type)
			 * -----------------------------------------------------------------------------
			 */
			array(
				'name'			=> esc_html__( 'Media type', 'orin' ),
				'desc'			=> esc_html__( 'This option applies to pages with posts. Default value: Slider.', 'orin' ),
				'id'			=> "{$prefix}gallery_thumb_type",
				'type'			=> 'select_advanced',
				'options'		=> array(
					'featured_image'	=> esc_html__( 'Featured image', 'orin' ),
					'slider'			=> esc_html__( 'Slider', 'orin' ),
				),
				'std'			=> 'slider',
				'multiple'		=> false,
				'placeholder'	=> esc_html__( 'Featured image / Slider', 'orin' ),
			),

			/**
			 * Images for the gallery
			 * -----------------------------------------------------------------------------
			 */
			array(
				'name'				=> esc_html__( 'Add images', 'orin' ),
				'id'				=> "{$prefix}gallery",
				'type'				=> 'image_advanced',
				'max_file_uploads'	=> 10,
			),

		),
	);


	/**
	 * Video format
	 * -----------------------------------------------------------------------------
	 */
	$meta_boxes[] = array(
		'id'		=> "{$prefix}video_format",
		'title'		=> esc_html__( 'Video Format Settings', 'orin' ),
		'pages'		=> array( 'post' ),
		'context'	=> 'normal',
		'priority'	=> 'high',
		'fields'	=> array(

			/**
			 * Thumbnail type (or media type)
			 * -----------------------------------------------------------------------------
			 */
			array(
				'name'			=> esc_html__( 'Media type', 'orin' ),
				'desc'			=> esc_html__( 'This option applies to pages with posts. Default value: Video player (iframe).', 'orin' ),
				'id'			=> "{$prefix}video_thumb_type",
				'type'			=> 'select_advanced',
				'options'		=> array(
					'iframe'			=> esc_html__( 'Video player (iframe)', 'orin' ),
					'featured_image'	=> esc_html__( 'Featured image', 'orin' ),
				),
				'std'			=> 'iframe',
				'multiple'		=> false,
				'placeholder'	=> esc_html__( 'Video player / Featured image', 'orin' ),
			),

			/**
			 * Video URL
			 * -----------------------------------------------------------------------------
			 */
			array(
				'name'	=> esc_html__( 'Video URL', 'orin' ),
				'id'	=> "{$prefix}video_url",
				'desc'	=> esc_html__( 'Insert a link (URL) on a video from one of the video hosting sites: YouTube, Vimeo, etc.', 'orin' ),
				'type'	=> 'oembed',
			),

		),
	);


	/**
	 * Audio format
	 * -----------------------------------------------------------------------------
	 */
	$meta_boxes[] = array(
		'id'		=> "{$prefix}audio_format",
		'title'		=>  esc_html__( 'Audio Format Settings', 'orin' ),
		'pages'		=> array( 'post' ),
		'context'	=> 'normal',
		'priority'	=> 'high',
		'fields'	=> array(

			/**
			 * Thumbnail type (or media type)
			 * -----------------------------------------------------------------------------
			 */
			array(
				'name'			=> esc_html__( 'Media type', 'orin' ),
				'desc'			=> esc_html__( 'This option applies to pages with posts. Default value: Audio player (iframe).', 'orin' ),
				'id'			=> "{$prefix}audio_thumb_type",
				'type'			=> 'select_advanced',
				'options'		=> array(
					'iframe'			=> esc_html__( 'Audio player (iframe)', 'orin' ),
					'featured_image'	=> esc_html__( 'Featured image', 'orin' ),
				),
				'std'			=> 'iframe',
				'multiple'		=> false,
				'placeholder'	=> esc_html__( 'Audio player / Featured image', 'orin' ),
			),

			/**
			 * Audio URL
			 * -----------------------------------------------------------------------------
			 */
			array(
				'name'	=> esc_html__( 'SoundCloud URL', 'orin' ),
				'id'	=> "{$prefix}audio_url",
				'desc'	=> esc_html__( 'Insert a link (URL) on a song from the SoundCloud service.', 'orin' ),
				'type'	=> 'oembed',
			),

		),
	);

	return $meta_boxes;

}
