<?php
/**
 * The template for displaying blog posts with pagination
 *
 * @package WordPress
 * @subpackage Orin
 * @since Orin 1.0
 */

if ( is_home() ) {

	// show the slider on the first page or on all pagination pages
	$show_slider_on_first_page = get_theme_mod( 'orin_show_slider_on_first_page', 0 ); // 1 or 0
	if ( $show_slider_on_first_page ) {
		// show the slider only on the first pagination page
		$show_slider = ( ! is_paged() ) ? 'show' : 'hide';
	} else {
		// show the slider on all pagination pages
		$show_slider = 'show';
	}

	// show slider
	if ( 'show' === $show_slider ) {
		get_template_part( 'templates/homepage-slider' );
	}

	// posts section title: visible or not
	$posts_section_title = get_theme_mod( 'orin_posts_section_title', 'Recent Articles' );
	$section_has_header = ( '' !== $posts_section_title ) ? 'bwp-section-has-header' : '';

} else {

	// on archive pages the posts section always has a title
	$section_has_header = 'bwp-section-has-header';

}
?>

<!-- section with recent posts -->
<section class="bwp-recent-posts-section bwp-site-section<?php if ( '' !== $section_has_header ) { echo ' ' . sanitize_html_class( $section_has_header ); } ?>">

	<?php
	// title and subtitle
	orin_show_archive_header();
	?>

	<!-- main section with posts -->
	<div class="bwp-posts" role="main">
		<div class="bwp-posts-wrap">

			<!-- masonry -->
			<div id="bwp-masonry" class="bwp-col-3-layout clearfix">
				<div class="bwp-col-size"></div><!-- width of .bwp-col-size used for columnWidth; this block must be empty -->

				<?php
				// start the loop
				if ( have_posts() ) :
					while ( have_posts() ) :
						the_post();
						$format = get_post_format();
						if ( false === $format ) {
							get_template_part( 'content', 'standard' );
						} else {
							get_template_part( 'content', $format );
						}
					endwhile;
				endif;
				// end the loop
				?>

			</div>
			<!-- end: masonry -->

			<?php
			// if no content, include the "No post found" template
			if ( ! have_posts() ) :
				get_template_part( 'content', 'none' );
			endif;
			?>

		</div>
	</div>
	<!-- end: main section with posts -->

	<?php
	// pagination
	the_posts_pagination( array(
		'prev_text' => '<i class="fas fa-chevron-left"></i>',
		'next_text' => '<i class="fas fa-chevron-right"></i>',
	) );
	?>

</section>
<!-- end: section with recent posts -->
