<?php
/**
 * Featured image (Appears in a post on all archive pages)
 *
 * @package WordPress
 * @subpackage Orin
 * @since Orin 1.0
 */

// if the post has a featured image
if ( has_post_thumbnail() ) {

	// image data: sizes and attributes
	$image_size = 'full';
	$image_attr = '';
	if ( ! is_singular() ) {
		// archive pages; add new attributes
		$image_attr = array( 'loading' => 'eager' );
	} else {
		// single pages; new size (900x600px)
		$image_size = 'orin-900-600-crop';
	}

	// link type
	$link_type = get_theme_mod( 'orin_featured_image_link_type', 'link_to_post' ); // 'link_to_image' or 'link_to_post'
	?>

	<!-- featured image -->
	<figure class="bwp-post-media">

		<?php
		// link type: link to image
		if ( 'link_to_image' === $link_type ) {
			// image id
			$image_id = get_post_thumbnail_id();
			// data for popup image
			$popup_image_size = 'full';
			$popup_image_url = wp_get_attachment_image_url( $image_id, $popup_image_size );
			$popup_image_caption = get_post( $image_id )->post_excerpt;
			?>

			<a href="<?php echo esc_url( $popup_image_url ); ?>" class="bwp-popup-image" title="<?php if ( $popup_image_caption ) { echo esc_attr( $popup_image_caption ); } else { the_title_attribute(); } ?>">
				<?php the_post_thumbnail( $image_size, $image_attr ); ?>
				<div class="bwp-post-media-overlay"></div>
				<span class="bwp-post-hover-icon bwp-expand-image">
					<i class="fas fa-images"></i>
				</span>
			</a>

			<?php
		} else {
			// link type: link to post
			?>

			<a href="<?php the_permalink(); ?>">
				<?php the_post_thumbnail( $image_size, $image_attr ); ?>
				<div class="bwp-post-media-overlay"></div>
				<span class="bwp-post-hover-icon">
					<i class="fas fa-share"></i>
				</span>
			</a>

			<?php
		}
		?>

	</figure>
	<!-- end: featured image -->

	<?php
}
