<?php
/**
 * The template for displaying all Single posts
 *
 * @package WordPress
 * @subpackage Orin
 * @since Orin 1.0
 */

// header
get_header();

// start the loop
while ( have_posts() ) : the_post();

	// post ID
	$blog_post_id = $post->ID;

	// post format
	$blog_post_format = get_post_format();
	if ( false === $blog_post_format ) {
		$blog_post_format = 'standard';
	}

	// increase the number of views
	if ( function_exists( 'orin_additional_features_increase_views' ) ) {
		orin_additional_features_increase_views( $blog_post_id );
	}

	// post with password or not
	$is_password_protected = post_password_required();

	// this is an attachment page or not
	$is_attachment_page = is_attachment();

	// tags: show or hide
	$show_tags_opt = get_theme_mod( 'orin_single_show_tags', 1 ); // 1 or 0
	$show_tags = false;
	if ( $show_tags_opt && get_the_tags() ) {
		$show_tags = true;
	}

	// social share buttons: show or hide
	$show_share_buttons_opt = get_theme_mod( 'orin_single_show_share_buttons', 1 ); // 1 or 0
	$show_share_buttons = function_exists( 'orin_additional_features_show_share_buttons' ) && $show_share_buttons_opt;
	?>

	<!-- main container with post -->
	<main class="bwp-single-post-container">
		<div class="bwp-separator bwp-gradient"><span class="bwp-rhomb"></span></div>

		<!-- single post -->
		<article id="bwp-post-<?php echo (int) $blog_post_id; ?>" <?php post_class(); ?>>

			<!-- header -->
			<header class="bwp-single-post-header<?php if ( ! orin_post_has_featured_media( $blog_post_id, $blog_post_format ) || $is_password_protected ) { echo ' bwp-no-featured-media'; } ?>">

				<?php
				// metadata (author, date, and categories)
				if ( ! $is_attachment_page ) {
					orin_show_single_post_metadata();
				}

				// title
				if ( get_the_title() ) {
					?>
					<!-- title -->
					<h1 class="bwp-post-title entry-title"><?php the_title(); ?></h1>
					<!-- end: title -->
					<?php
				}
				?>

				<div class="bwp-single-post-header-separator"></div>
			</header>
			<!-- end: header -->

			<?php
			// media (featured image / slider / video / audio)
			if ( ! $is_password_protected && ! $is_attachment_page ) {
				if ( 'gallery' === $blog_post_format || 'video' === $blog_post_format || 'audio' === $blog_post_format ) {
					get_template_part( 'templates/single-post-media/media', $blog_post_format );
				} else {
					get_template_part( 'templates/single-post-media/media', 'image' );
				}
			}
			?>

			<!-- content container -->
			<div class="bwp-single-post-content">

				<!-- content -->
				<div class="bwp-content entry-content clearfix">

					<?php
					// content
					the_content();
					?>

					<!-- clearfix -->
					<div class="clearfix"></div>

					<?php
					// pagination
					wp_link_pages( array(
						'before'			=> '<nav class="bwp-single-post-pagination clearfix"><span>' . esc_html__( 'Pages:', 'orin' ) . '</span>',
						'after'				=> '</nav>',
						'next_or_number'	=> 'number',
					) );
					?>

				</div>
				<!-- end: content -->

				<?php
				// tags and share buttons
				if ( ! $is_password_protected ) {
					if ( $show_tags && $show_share_buttons ) {
						?>

						<!-- tags and share buttons -->
						<div class="bwp-single-post-tags-share clearfix">

							<?php
							// tags
							orin_show_single_post_tags();

							// share buttons
							orin_additional_features_show_share_buttons();
							?>

						</div>
						<!-- end: tags and share buttons -->

						<?php
					} elseif ( $show_tags ) {
						?>

						<!-- container with tags -->
						<div class="bwp-single-post-tags-container clearfix">
							<?php orin_show_single_post_tags(); ?>
						</div>
						<!-- end: container with tags -->

						<?php
					} elseif ( $show_share_buttons ) {
						?>

						<!-- container with share buttons -->
						<div class="bwp-single-post-share-container clearfix">
							<?php orin_additional_features_show_share_buttons(); ?>
						</div>
						<!-- end: container with share buttons -->

						<?php
					}
				}
				?>

			</div>
			<!-- end: content container -->

		</article>
		<!-- end: single post -->

		<?php
		// about the author
		$show_about_author = get_theme_mod( 'orin_single_show_about_author', 0 ); // 1 or 0
		if ( ! $is_password_protected && ! $is_attachment_page && $show_about_author ) {
			orin_show_about_the_author();
		}

		// post navigation
		$show_post_navigation = get_theme_mod( 'orin_single_show_post_navigation', 1 ); // 1 or 0
		if ( ! $is_attachment_page && $show_post_navigation ) {
			?>

			<!-- post navigation -->
			<div class="bwp-single-post-navigation">
				<div class="bwp-separator bwp-gradient"><span class="bwp-rhomb"></span></div>
				<div class="bwp-single-post-navigation-container">
					<?php
					// navigation links
					the_post_navigation( array(
						'prev_text'	=> '<span class="meta-nav"><i class="fas fa-chevron-left"></i>' . esc_html__( 'Previous post', 'orin' ) . '</span><span class="post-title-nav">%title</span>',
						'next_text'	=> '<span class="meta-nav">' . esc_html__( 'Next post', 'orin' ) . '<i class="fas fa-chevron-right"></i></span><span class="post-title-nav">%title</span>',
					) );
					?>
				</div>
			</div>
			<!-- end: post navigation -->

			<?php
		}

		// comments
		if ( comments_open() || get_comments_number() ) {
			comments_template();
		}

		// related posts (by tags)
		if ( ! $is_password_protected && ! $is_attachment_page ) {
			get_template_part( 'templates/related-posts' );
		}
		?>

		<div class="bwp-separator bwp-gradient"><span class="bwp-rhomb"></span></div>
	</main>
	<!-- end: main container with post -->

	<?php
endwhile;
// end of the loop

// footer
get_footer();
