<?php
/**
 * The template for displaying the footer
 *
 * @package WordPress
 * @subpackage Orin
 * @since Orin 1.0
 */

// show section with widgets
$footer_has_widgets = false;
if ( is_active_sidebar( 'orin_footer_sidebar_left' ) || is_active_sidebar( 'orin_footer_sidebar_center' ) || is_active_sidebar( 'orin_footer_sidebar_right' ) ) {
	$footer_has_widgets = true;
	?>

	<!-- footer widgets -->
	<section class="bwp-footer-widgets-section" role="complementary">
		<h2 class="screen-reader-text">
			<?php esc_html_e( 'Widgets', 'orin' ); ?>
		</h2>
		<div class="bwp-separator bwp-gradient">
			<span class="bwp-rhomb"></span>
		</div>
		<div class="row">

			<!-- column 1 (left column) -->
			<div class="col-md-4">
				<div class="bwp-footer-widgets-col-1 bwp-sidebar-content bwp-content">
					<?php
					if ( is_active_sidebar( 'orin_footer_sidebar_left' ) ) {
						dynamic_sidebar( 'orin_footer_sidebar_left' );
					}
					?>
				</div>
			</div>
			<!-- end: column 1 -->

			<!-- column 2 (center column) -->
			<div class="col-md-4">
				<div class="bwp-footer-widgets-col-2 bwp-sidebar-content bwp-content">
					<?php
					if ( is_active_sidebar( 'orin_footer_sidebar_center' ) ) {
						dynamic_sidebar( 'orin_footer_sidebar_center' );
					}
					?>
				</div>
			</div>
			<!-- end: column 2 -->

			<!-- column 3 (right column) -->
			<div class="col-md-4">
				<div class="bwp-footer-widgets-col-3 bwp-sidebar-content bwp-content">
					<?php
					if ( is_active_sidebar( 'orin_footer_sidebar_right' ) ) {
						dynamic_sidebar( 'orin_footer_sidebar_right' );
					}
					?>
				</div>
			</div>
			<!-- end: column 3 -->

		</div>
		<div class="bwp-separator bwp-gradient">
			<span class="bwp-rhomb"></span>
		</div>
	</section>
	<!-- end: footer widgets -->

	<?php
}
// end: widgets

// footer text
$footer_text = get_theme_mod( 'orin_footer_text', '' );
// footer menu: exists or not
$footer_menu_exists = has_nav_menu( 'orin_footer_menu' );

// show footer
if ( '' !== $footer_text || $footer_menu_exists ) {
	?>

	<!-- footer -->
	<footer class="bwp-site-footer<?php if ( $footer_has_widgets ) { echo ' bwp-footer-has-widgets'; } ?>">

		<?php
		// footer text
		if ( '' !== $footer_text ) {
			?>

			<!-- footer text -->
			<div class="bwp-footer-text">
				<?php
				echo wp_kses( $footer_text, array(
					'p'			=> array(
						'class'		=> array(),
					),
					'a'			=> array(
						'href'		=> array(),
						'title'		=> array(),
						'target'	=> array(),
						'class'		=> array(),
						'rel'		=> array(),
					),
					'span'		=> array(
						'class'		=> array(),
					),
					'strong'	=> array(),
					'b'			=> array(),
					'em'		=> array(),
					'i'			=> array(
						'class'		=> array(),
					),
					'br'		=> array(),
				) );
				?>
			</div>
			<!-- end: footer text -->

			<?php
		}

		// footer menu
		if ( $footer_menu_exists ) {
			?>

			<!-- footer menu -->
			<div class="bwp-footer-menu">
				<?php
				// show footer menu (no dropdown menu support)
				wp_nav_menu( array(
					'theme_location'	=> 'orin_footer_menu',
					'container'			=> 'nav',
					'menu_class'		=> 'bwp-footer-menu-list list-unstyled',
					'depth'				=> 1,
				) );
				?>
			</div>
			<!-- end: footer menu -->

			<?php
		}
		?>

	</footer>
	<!-- end: footer -->

	<?php
}
// end: footer
?>

</div><!-- end: .container -->
</div><!-- end: .bwp-site-content -->
<!-- end: container with site content -->

<?php
// back to top
$show_back_to_top = get_theme_mod( 'orin_show_back_to_top', 1 ); // 1 or 0
if ( $show_back_to_top ) {
	?>

	<!-- button: "back to top" -->
	<div id="bwp-scroll-top">
		<button type="button" class="bwp-button bwp-scroll-top-button">
			<i class="fas fa-chevron-up"></i>
		</button>
	</div>
	<!-- end: button -->

	<?php
}
// end: back to top

// main sidebar (id: orin_sidebar)
if ( is_active_sidebar( 'orin_sidebar' ) && get_theme_mod( 'orin_show_sidebar_button', 1 ) ) {
	?>

	<!-- sidebar (hidden right sidebar) -->
	<aside class="bwp-sidebar">

		<!-- button: hide sidebar -->
		<button type="button" class="bwp-button bwp-hide-sidebar bwp-hide-sidebar-button">
			<i class="fas fa-times"></i>
		</button>
		<!-- end: button -->

		<!-- content -->
		<div class="bwp-sidebar-content-container bwp-sidebar-content bwp-content">
			<?php dynamic_sidebar( 'orin_sidebar' ); ?>
		</div>
		<!-- end: content -->

	</aside>
	<!-- end: sidebar -->

	<!-- sidebar overlay -->
	<div class="bwp-sidebar-overlay bwp-hide-sidebar"></div>
	<!-- end: sidebar overlay -->

	<?php
}
// end: main sidebar

// cookies notice (show only if the "Orin Additional Features" plugin is activated)
if ( function_exists( 'orin_additional_features_show_cookies_notice' ) ) {
	orin_additional_features_show_cookies_notice();
}

wp_footer();
?>
</body>
</html>
