<?php
/**
 * Inline styles
 *
 * @package WordPress
 * @subpackage Orin
 * @since Orin 1.0
 */

function orin_inline_styles() {

	$inline_styles = '';

	/**
	 * Some additional styles
	 * -------------------------------------------------------------
	 */

	// The effect when hovering over the post
	if ( ! wp_is_mobile() ) {
		$inline_styles .= '
		.bwp-post-wrap:hover .bwp-post-content::before {
			width: 30px;
		}';
	}


	/**
	 * Customizer Section -> Site Identity
	 * -------------------------------------------------------------
	 */

	// Logo width (id: orin_logo_width)
	$logo_width = get_theme_mod( 'orin_logo_width' );
	if ( $logo_width ) {
		$inline_styles .= '
		.bwp-logo-container .custom-logo-link img {
			width: ' . $logo_width . 'px;
		}';
	}


	/**
	 * Customizer Section -> Blog Posts
	 * -------------------------------------------------------------
	 */

	// Increase the size of small images (id: orin_increase_images)
	$increase_images = get_theme_mod( 'orin_increase_images', 0 ); // 1 or 0
	if ( $increase_images ) {
		$inline_styles .= '
		.bwp-post-media img,
		.bwp-post-slider-item img {
			width: 100%;
			margin: 0;
		}';
	}

	// Disable hover effects when hovering over images (id: orin_images_hover_effects)
	$images_hover_effects = get_theme_mod( 'orin_images_hover_effects', 0 ); // 1 or 0
	if ( ! $images_hover_effects ) {
		$inline_styles .= '
		.bwp-post-media-overlay,
		.bwp-post-hover-icon {
			display: none;
		}';
	}

	// Show/hide categories (id: orin_posts_show_categories)
	$show_categories_on_posts = get_theme_mod( 'orin_posts_show_categories', 1 ); // 1 or 0
	if ( ! $show_categories_on_posts ) {
		$inline_styles .= '
		.bwp-posts .bwp-post-metadata {
			display: none;
		}';
	}


	/**
	 * Customizer Section -> Colors And Cookies
	 * -------------------------------------------------------------
	 */

	// Hover/active color (Light style; id: orin_light_style_hover_color)
	$light_style_hover_color = get_theme_mod( 'orin_light_style_hover_color', '#6f6fff' );
	if ( '#6f6fff' !== $light_style_hover_color ) {
		$inline_styles .= '
		a:hover,
		a:focus,
		h1 a:hover,
		h2 a:hover,
		h3 a:hover,
		h4 a:hover,
		h5 a:hover,
		h6 a:hover,
		h1 a:focus,
		h2 a:focus,
		h3 a:focus,
		h4 a:focus,
		h5 a:focus,
		h6 a:focus,
		.sf-menu a:hover,
		.sf-menu a:focus,
		.sf-menu > li:hover > a,
		.sf-menu > .current-menu-item > a,
		.sf-menu > .current-menu-ancestor > a,
		.sf-menu > .current-menu-ancestor > .sf-with-ul::after,
		.sf-menu ul li a:hover,
		.sf-menu ul > li:hover > a,
		.sf-menu ul > .current-menu-item > a,
		.sf-menu ul > .current-menu-ancestor > a,
		.sf-menu ul > .current-menu-ancestor > .sf-with-ul::after,
		.sf-arrows > li > .sf-with-ul:focus::after,
		.sf-arrows > li:hover > .sf-with-ul::after,
		.sf-arrows > .sfHover > .sf-with-ul::after,
		.sf-arrows ul li > .sf-with-ul:focus::after,
		.sf-arrows ul li:hover > .sf-with-ul::after,
		.sf-arrows ul .sfHover > .sf-with-ul::after,
		#bwp-toggle-mobile-menu:hover,
		#bwp-toggle-mobile-menu.bwp-active,
		.bwp-mobile-menu li a:hover,
		.bwp-mobile-menu .current-menu-item > a,
		.bwp-toggle-mobile-submenu:hover,
		.bwp-mobile-menu li.bwp-submenu-visible > a,
		.bwp-mobile-menu li.bwp-submenu-visible > a .bwp-toggle-mobile-submenu,
		.bwp-header-sidebar-button:hover,
		.bwp-header-sidebar-button:focus,
		#bwp-toggle-dropdown-search:hover,
		#bwp-toggle-dropdown-search:focus,
		#bwp-toggle-dropdown-search.bwp-active,
		#bwp-dropdown-search #searchform .bwp-search-submit:hover,
		#bwp-dropdown-search #searchform .bwp-search-submit:focus,
		#bwp-toggle-color:hover,
		#bwp-toggle-color:focus,
		#bwp-show-font-types:hover,
		#bwp-show-font-types:focus,
		#bwp-show-font-types.bwp-active,
		.bwp-font-type:not(.bwp-active):hover,
		.bwp-logo-text:hover,
		.bwp-logo-text:focus,
		.bwp-post-metadata li a:hover,
		.bwp-post-metadata li a:focus,
		.bwp-post-read-more a:hover,
		.bwp-post-read-more a:focus,
		.bwp-post-counters a:hover,
		.bwp-post-counters a:focus,
		.bwp-no-results p a:hover,
		.bwp-no-results p a:focus,
		.pagination .nav-links a.page-numbers:hover,
		.pagination .nav-links a.page-numbers:focus,
		.bwp-single-post-metadata li a:hover,
		.bwp-single-post-metadata li a:focus,
		.wp-playlist .wp-playlist-item a:hover,
		.bwp-content .bwp-single-post-pagination a:hover,
		.bwp-content .bwp-single-post-pagination a:focus,
		.bwp-content .wp-block-calendar .wp-calendar-nav a:hover,
		.bwp-content .wp-block-calendar .wp-calendar-nav a:focus,
		.bwp-content .wp-block-latest-comments .wp-block-latest-comments__comment-meta a:hover,
		.bwp-content .wp-block-latest-comments .wp-block-latest-comments__comment-meta a:focus,
		.bwp-content .wp-block-latest-posts .wp-block-latest-posts__post-excerpt a:hover,
		.bwp-content .wp-block-latest-posts .wp-block-latest-posts__post-excerpt a:focus,
		.bwp-content .wp-block-latest-posts .wp-block-latest-posts__post-full-content a:hover,
		.bwp-content .wp-block-latest-posts .wp-block-latest-posts__post-full-content a:focus,
		.bwp-content .wp-block-tag-cloud a:hover .tag-link-count,
		.bwp-content .wp-block-tag-cloud a:focus .tag-link-count,
		.bwp-about-author-name a:hover,
		.bwp-about-author-name a:focus,
		.post-navigation .nav-links a:hover,
		.post-navigation .nav-links a:focus,
		.comment-form-cookies-consent label:hover,
		.comment-respond .must-log-in a:hover,
		.comment-respond .must-log-in a:focus,
		.comment-form .logged-in-as a:hover,
		.comment-form .logged-in-as a:focus,
		.comment-reply-title #cancel-comment-reply-link:hover,
		.bwp-comment-list .comment-meta .comment-author .fn .url:hover,
		.bwp-comment-list .comment-meta .comment-author .fn .url:focus,
		.bwp-comment-list .comment-meta .comment-metadata a:hover,
		.bwp-comment-list .comment-meta .comment-metadata a:focus,
		.bwp-comment-list .pingback .comment-body > a:hover,
		.bwp-comment-list .pingback .comment-body > a:focus,
		.bwp-comment-list .trackback .comment-body > a:hover,
		.bwp-comment-list .trackback .comment-body > a:focus,
		.comment-navigation .nav-links a:hover,
		.comment-navigation .nav-links a:focus,
		.bwp-related-posts-list .post .bwp-post-metadata li a:hover,
		.bwp-related-posts-list .post .bwp-post-metadata li a:focus,
		.bwp-single-page-random-posts-list .post .bwp-post-metadata li a:hover,
		.bwp-single-page-random-posts-list .post .bwp-post-metadata li a:focus,
		.bwp-page-404-content p a:hover,
		.bwp-page-404-content p a:focus,
		.bwp-footer-text a:hover,
		.bwp-footer-text a:focus,
		.bwp-footer-menu-list li a:hover,
		.bwp-footer-menu-list li a:focus,
		.bwp-hide-sidebar-button:hover,
		.bwp-hide-sidebar-button:focus,
		.bwp-widget a:hover,
		.bwp-widget a:focus,
		.bwp-widget .bwp-widget-title a:hover,
		.bwp-widget .bwp-widget-title a:focus,
		.bwp-sidebar-content ul.wp-block-latest-posts > li > a:hover,
		.bwp-sidebar-content ul.wp-block-latest-posts > li > a:focus,
		.widget_tag_cloud .tagcloud a:hover .tag-link-count,
		.widget_tag_cloud .tagcloud a:focus .tag-link-count,
		.widget_calendar .wp-calendar-nav a:hover,
		.widget_calendar .wp-calendar-nav a:focus,
		.bwp-sidebar-content .wp-block-latest-comments:not(.has-avatars) .wp-block-latest-comments__comment-meta a:hover,
		.bwp-sidebar-content .wp-block-latest-comments:not(.has-avatars) .wp-block-latest-comments__comment-meta a:focus,
		.widget_search #searchform .bwp-search-submit:hover,
		.widget_bwp_popular_posts > ul > li:hover .widget_bwp_popular_post_num,
		.widget_bwp_content h4 a:hover,
		.widget_bwp_content h4 a:focus,
		.widget_bwp_meta li a:hover,
		.widget_bwp_meta li a:focus,
		#bwp-hide-cookies-info:hover,
		.bwp-content .wp-block-post-template .wp-block-post-excerpt__more-link:hover,
		.bwp-content .wp-block-post-template .wp-block-post-excerpt__more-link:focus,
		.bwp-content .wp-block-post-template .wp-block-post-date a:hover,
		.bwp-content .wp-block-post-template .wp-block-post-date a:focus,
		.bwp-content .wp-block-comment-template .wp-block-comment-date a:hover,
		.bwp-content .wp-block-comment-template .wp-block-comment-edit-link a:hover,
		.bwp-content .wp-block-comment-template .wp-block-comment-date a:focus,
		.bwp-content .wp-block-comment-template .wp-block-comment-edit-link a:focus,
		.bwp-content .wp-block-comment-template .wp-block-comment-reply-link a:hover,
		.bwp-content .wp-block-comment-template .wp-block-comment-reply-link a:focus {
			color: ' . $light_style_hover_color . ';
		}
		input[type="text"]:not(.bwp-search-field):hover,
		input[type="email"]:hover,
		input[type="url"]:hover,
		input[type="password"]:hover,
		input[type="search"]:hover,
		input[type="tel"]:hover,
		input[type="number"]:hover,
		input[type="date"]:hover,
		textarea:hover,
		select:hover,
		input[type="text"]:not(.bwp-search-field):focus,
		input[type="email"]:focus,
		input[type="url"]:focus,
		input[type="password"]:focus,
		input[type="search"]:focus,
		input[type="tel"]:focus,
		input[type="number"]:focus,
		input[type="date"]:focus,
		textarea:focus,
		select:focus,
		input[type="file"]:hover,
		input[type="file"]:focus,
		input[type="checkbox"]:hover,
		input[type="radio"]:hover,
		.bwp-content .wp-block-search .wp-block-search__input:hover,
		.bwp-content .wp-block-search .wp-block-search__input:focus,
		.widget_search #searchform:hover,
		.widget_search #searchform:focus,
		.bwp-content .wp-block-post-comments-form .comment-form-comment textarea:hover,
		.bwp-content .wp-block-post-comments-form .comment-form-author input:hover,
		.bwp-content .wp-block-post-comments-form .comment-form-email input:hover,
		.bwp-content .wp-block-post-comments-form .comment-form-url input:hover,
		.bwp-content .wp-block-post-comments-form .comment-form-comment textarea:focus,
		.bwp-content .wp-block-post-comments-form .comment-form-author input:focus,
		.bwp-content .wp-block-post-comments-form .comment-form-email input:focus,
		.bwp-content .wp-block-post-comments-form .comment-form-url input:focus,
		.bwp-content .wp-block-post-comments-form .comment-form-cookies-consent input:hover,
		.bwp-content .wp-block-post-comments-form .comment-form-cookies-consent input:focus {
			border-color: ' . $light_style_hover_color . ';
		}
		input[type="checkbox"]:checked,
		input[type="radio"]:checked {
			background: ' . $light_style_hover_color . ';
			border-color: ' . $light_style_hover_color . ';
		}
		input[type="button"]:hover,
		input[type="reset"]:hover,
		input[type="submit"]:hover,
		.bwp-homepage-slider-wrap .tns-controls button:hover,
		.bwp-post-media-slider .tns-controls button:hover,
		.bwp-content .wp-block-file a.wp-block-file__button:active,
		.bwp-content .wp-block-file a.wp-block-file__button:focus,
		.bwp-content .wp-block-file a.wp-block-file__button:hover,
		.bwp-content .wp-block-search .wp-block-search__button:hover,
		.bwp-content .wp-block-search .wp-block-search__button:focus,
		.bwp-scroll-top-button:hover,
		#bwp-accept-cookies:hover {
			background: ' . $light_style_hover_color . ';
		}
		.bwp-font-type.bwp-active,
		.bwp-homepage-slider-zoom-image:hover,
		.pagination .nav-links .page-numbers.current,
		.bwp-single-post-tags a:hover,
		.bwp-single-post-tags a:focus,
		.bwp-content .bwp-single-post-pagination .post-page-numbers.current,
		.bwp-comment-list .comment-body .reply a:hover,
		.bwp-comment-list .pingback .comment-body .edit-link a:hover,
		.bwp-comment-list .trackback .comment-body .edit-link a:hover,
		.widget_bwp_social ul li a:hover,
		.widget_bwp_social ul li a:focus,
		.bwp-content .wp-block-query-pagination .page-numbers.current,
		.bwp-content .wp-block-comments-pagination .page-numbers.current {
			background-color: ' . $light_style_hover_color . ';
		}';
	}

	// Hover/active color (Dark style; id: orin_dark_style_hover_color)
	$dark_style_hover_color = get_theme_mod( 'orin_dark_style_hover_color', '#8585ff' );
	if ( '#8585ff' !== $dark_style_hover_color ) {
		$inline_styles .= '
		.bwp-dark-style a:hover,
		.bwp-dark-style a:focus,
		.bwp-dark-style h1 a:hover,
		.bwp-dark-style h2 a:hover,
		.bwp-dark-style h3 a:hover,
		.bwp-dark-style h4 a:hover,
		.bwp-dark-style h5 a:hover,
		.bwp-dark-style h6 a:hover,
		.bwp-dark-style h1 a:focus,
		.bwp-dark-style h2 a:focus,
		.bwp-dark-style h3 a:focus,
		.bwp-dark-style h4 a:focus,
		.bwp-dark-style h5 a:focus,
		.bwp-dark-style h6 a:focus,
		.bwp-dark-style .sf-menu a:hover,
		.bwp-dark-style .sf-menu a:focus,
		.bwp-dark-style .sf-menu > li:hover > a,
		.bwp-dark-style .sf-menu > .current-menu-item > a,
		.bwp-dark-style .sf-menu > .current-menu-ancestor > a,
		.bwp-dark-style .sf-menu > .current-menu-ancestor > .sf-with-ul::after,
		.bwp-dark-style .sf-menu ul li a:hover,
		.bwp-dark-style .sf-menu ul > li:hover > a,
		.bwp-dark-style .sf-menu ul > .current-menu-item > a,
		.bwp-dark-style .sf-menu ul > .current-menu-ancestor > a,
		.bwp-dark-style .sf-menu ul > .current-menu-ancestor > .sf-with-ul::after,
		.bwp-dark-style .sf-arrows > li > .sf-with-ul:focus::after,
		.bwp-dark-style .sf-arrows > li:hover > .sf-with-ul::after,
		.bwp-dark-style .sf-arrows > .sfHover > .sf-with-ul::after,
		.bwp-dark-style .sf-arrows ul li > .sf-with-ul:focus::after,
		.bwp-dark-style .sf-arrows ul li:hover > .sf-with-ul::after,
		.bwp-dark-style .sf-arrows ul .sfHover > .sf-with-ul::after,
		.bwp-dark-style #bwp-toggle-mobile-menu:hover,
		.bwp-dark-style #bwp-toggle-mobile-menu.bwp-active,
		.bwp-dark-style .bwp-mobile-menu li a:hover,
		.bwp-dark-style .bwp-mobile-menu .current-menu-item > a,
		.bwp-dark-style .bwp-toggle-mobile-submenu:hover,
		.bwp-dark-style .bwp-mobile-menu li.bwp-submenu-visible > a,
		.bwp-dark-style .bwp-mobile-menu li.bwp-submenu-visible > a .bwp-toggle-mobile-submenu,
		.bwp-dark-style .bwp-header-sidebar-button:hover,
		.bwp-dark-style .bwp-header-sidebar-button:focus,
		.bwp-dark-style #bwp-toggle-dropdown-search:hover,
		.bwp-dark-style #bwp-toggle-dropdown-search:focus,
		.bwp-dark-style #bwp-toggle-dropdown-search.bwp-active,
		.bwp-dark-style #bwp-dropdown-search #searchform .bwp-search-submit:hover,
		.bwp-dark-style #bwp-dropdown-search #searchform .bwp-search-submit:focus,
		.bwp-dark-style #bwp-toggle-color:hover,
		.bwp-dark-style #bwp-toggle-color:focus,
		.bwp-dark-style #bwp-show-font-types:hover,
		.bwp-dark-style #bwp-show-font-types:focus,
		.bwp-dark-style #bwp-show-font-types.bwp-active,
		.bwp-dark-style .bwp-font-type:not(.bwp-active):hover,
		.bwp-dark-style .bwp-logo-text:hover,
		.bwp-dark-style .bwp-logo-text:focus,
		.bwp-dark-style .bwp-post-metadata li a:hover,
		.bwp-dark-style .bwp-post-metadata li a:focus,
		.bwp-dark-style .bwp-post-read-more a:hover,
		.bwp-dark-style .bwp-post-read-more a:focus,
		.bwp-dark-style .bwp-post-counters a:hover,
		.bwp-dark-style .bwp-post-counters a:focus,
		.bwp-dark-style .bwp-no-results p a:hover,
		.bwp-dark-style .bwp-no-results p a:focus,
		.bwp-dark-style .pagination .nav-links a.page-numbers:hover,
		.bwp-dark-style .pagination .nav-links a.page-numbers:focus,
		.bwp-dark-style .bwp-single-post-metadata li a:hover,
		.bwp-dark-style .bwp-single-post-metadata li a:focus,
		.bwp-dark-style .wp-playlist .wp-playlist-item a:hover,
		.bwp-dark-style .bwp-content .bwp-single-post-pagination a:hover,
		.bwp-dark-style .bwp-content .bwp-single-post-pagination a:focus,
		.bwp-dark-style .bwp-content .wp-block-calendar .wp-calendar-nav a:hover,
		.bwp-dark-style .bwp-content .wp-block-calendar .wp-calendar-nav a:focus,
		.bwp-dark-style .bwp-content .wp-block-latest-comments .wp-block-latest-comments__comment-meta a:hover,
		.bwp-dark-style .bwp-content .wp-block-latest-comments .wp-block-latest-comments__comment-meta a:focus,
		.bwp-dark-style .bwp-content .wp-block-latest-posts .wp-block-latest-posts__post-excerpt a:hover,
		.bwp-dark-style .bwp-content .wp-block-latest-posts .wp-block-latest-posts__post-excerpt a:focus,
		.bwp-dark-style .bwp-content .wp-block-latest-posts .wp-block-latest-posts__post-full-content a:hover,
		.bwp-dark-style .bwp-content .wp-block-latest-posts .wp-block-latest-posts__post-full-content a:focus,
		.bwp-dark-style .bwp-content .wp-block-tag-cloud a:hover .tag-link-count,
		.bwp-dark-style .bwp-content .wp-block-tag-cloud a:focus .tag-link-count,
		.bwp-dark-style .bwp-about-author-name a:hover,
		.bwp-dark-style .bwp-about-author-name a:focus,
		.bwp-dark-style .post-navigation .nav-links a:hover,
		.bwp-dark-style .post-navigation .nav-links a:focus,
		.bwp-dark-style .comment-form-cookies-consent label:hover,
		.bwp-dark-style .comment-respond .must-log-in a:hover,
		.bwp-dark-style .comment-respond .must-log-in a:focus,
		.bwp-dark-style .comment-form .logged-in-as a:hover,
		.bwp-dark-style .comment-form .logged-in-as a:focus,
		.bwp-dark-style .comment-reply-title #cancel-comment-reply-link:hover,
		.bwp-dark-style .bwp-comment-list .comment-meta .comment-author .fn .url:hover,
		.bwp-dark-style .bwp-comment-list .comment-meta .comment-author .fn .url:focus,
		.bwp-dark-style .bwp-comment-list .comment-meta .comment-metadata a:hover,
		.bwp-dark-style .bwp-comment-list .comment-meta .comment-metadata a:focus,
		.bwp-dark-style .bwp-comment-list .pingback .comment-body > a:hover,
		.bwp-dark-style .bwp-comment-list .pingback .comment-body > a:focus,
		.bwp-dark-style .bwp-comment-list .trackback .comment-body > a:hover,
		.bwp-dark-style .bwp-comment-list .trackback .comment-body > a:focus,
		.bwp-dark-style .comment-navigation .nav-links a:hover,
		.bwp-dark-style .comment-navigation .nav-links a:focus,
		.bwp-dark-style .bwp-related-posts-list .post .bwp-post-metadata li a:hover,
		.bwp-dark-style .bwp-related-posts-list .post .bwp-post-metadata li a:focus,
		.bwp-dark-style .bwp-single-page-random-posts-list .post .bwp-post-metadata li a:hover,
		.bwp-dark-style .bwp-single-page-random-posts-list .post .bwp-post-metadata li a:focus,
		.bwp-dark-style .bwp-page-404-content p a:hover,
		.bwp-dark-style .bwp-page-404-content p a:focus,
		.bwp-dark-style .bwp-footer-text a:hover,
		.bwp-dark-style .bwp-footer-text a:focus,
		.bwp-dark-style .bwp-footer-menu-list li a:hover,
		.bwp-dark-style .bwp-footer-menu-list li a:focus,
		.bwp-dark-style .bwp-hide-sidebar-button:hover,
		.bwp-dark-style .bwp-hide-sidebar-button:focus,
		.bwp-dark-style .bwp-widget a:hover,
		.bwp-dark-style .bwp-widget a:focus,
		.bwp-dark-style .bwp-widget .bwp-widget-title a:hover,
		.bwp-dark-style .bwp-widget .bwp-widget-title a:focus,
		.bwp-dark-style .bwp-sidebar-content ul.wp-block-latest-posts > li > a:hover,
		.bwp-dark-style .bwp-sidebar-content ul.wp-block-latest-posts > li > a:focus,
		.bwp-dark-style .widget_tag_cloud .tagcloud a:hover .tag-link-count,
		.bwp-dark-style .widget_tag_cloud .tagcloud a:focus .tag-link-count,
		.bwp-dark-style .widget_calendar .wp-calendar-nav a:hover,
		.bwp-dark-style .widget_calendar .wp-calendar-nav a:focus,
		.bwp-dark-style .bwp-sidebar-content .wp-block-latest-comments:not(.has-avatars) .wp-block-latest-comments__comment-meta a:hover,
		.bwp-dark-style .bwp-sidebar-content .wp-block-latest-comments:not(.has-avatars) .wp-block-latest-comments__comment-meta a:focus,
		.bwp-dark-style .widget_search #searchform .bwp-search-submit:hover,
		.bwp-dark-style .widget_bwp_popular_posts > ul > li:hover .widget_bwp_popular_post_num,
		.bwp-dark-style .widget_bwp_content h4 a:hover,
		.bwp-dark-style .widget_bwp_content h4 a:focus,
		.bwp-dark-style .widget_bwp_meta li a:hover,
		.bwp-dark-style .widget_bwp_meta li a:focus,
		.bwp-dark-style #bwp-hide-cookies-info:hover,
		.bwp-dark-style .bwp-content .wp-block-post-template .wp-block-post-excerpt__more-link:hover,
		.bwp-dark-style .bwp-content .wp-block-post-template .wp-block-post-excerpt__more-link:focus,
		.bwp-dark-style .bwp-content .wp-block-post-template .wp-block-post-date a:hover,
		.bwp-dark-style .bwp-content .wp-block-post-template .wp-block-post-date a:focus,
		.bwp-dark-style .bwp-content .wp-block-comment-template .wp-block-comment-date a:hover,
		.bwp-dark-style .bwp-content .wp-block-comment-template .wp-block-comment-edit-link a:hover,
		.bwp-dark-style .bwp-content .wp-block-comment-template .wp-block-comment-date a:focus,
		.bwp-dark-style .bwp-content .wp-block-comment-template .wp-block-comment-edit-link a:focus,
		.bwp-dark-style .bwp-content .wp-block-comment-template .wp-block-comment-reply-link a:hover,
		.bwp-dark-style .bwp-content .wp-block-comment-template .wp-block-comment-reply-link a:focus {
			color: ' . $dark_style_hover_color . ';
		}
		.bwp-dark-style input[type="text"]:not(.bwp-search-field):hover,
		.bwp-dark-style input[type="email"]:hover,
		.bwp-dark-style input[type="url"]:hover,
		.bwp-dark-style input[type="password"]:hover,
		.bwp-dark-style input[type="search"]:hover,
		.bwp-dark-style input[type="tel"]:hover,
		.bwp-dark-style input[type="number"]:hover,
		.bwp-dark-style input[type="date"]:hover,
		.bwp-dark-style textarea:hover,
		.bwp-dark-style select:hover,
		.bwp-dark-style input[type="text"]:not(.bwp-search-field):focus,
		.bwp-dark-style input[type="email"]:focus,
		.bwp-dark-style input[type="url"]:focus,
		.bwp-dark-style input[type="password"]:focus,
		.bwp-dark-style input[type="search"]:focus,
		.bwp-dark-style input[type="tel"]:focus,
		.bwp-dark-style input[type="number"]:focus,
		.bwp-dark-style input[type="date"]:focus,
		.bwp-dark-style textarea:focus,
		.bwp-dark-style select:focus,
		.bwp-dark-style input[type="file"]:hover,
		.bwp-dark-style input[type="file"]:focus,
		.bwp-dark-style input[type="checkbox"]:hover,
		.bwp-dark-style input[type="radio"]:hover,
		.bwp-dark-style .bwp-content .wp-block-search .wp-block-search__input:hover,
		.bwp-dark-style .bwp-content .wp-block-search .wp-block-search__input:focus,
		.bwp-dark-style .widget_search #searchform:hover,
		.bwp-dark-style .widget_search #searchform:focus,
		.bwp-dark-style .bwp-content .wp-block-post-comments-form .comment-form-comment textarea:hover,
		.bwp-dark-style .bwp-content .wp-block-post-comments-form .comment-form-author input:hover,
		.bwp-dark-style .bwp-content .wp-block-post-comments-form .comment-form-email input:hover,
		.bwp-dark-style .bwp-content .wp-block-post-comments-form .comment-form-url input:hover,
		.bwp-dark-style .bwp-content .wp-block-post-comments-form .comment-form-comment textarea:focus,
		.bwp-dark-style .bwp-content .wp-block-post-comments-form .comment-form-author input:focus,
		.bwp-dark-style .bwp-content .wp-block-post-comments-form .comment-form-email input:focus,
		.bwp-dark-style .bwp-content .wp-block-post-comments-form .comment-form-url input:focus,
		.bwp-dark-style .bwp-content .wp-block-post-comments-form .comment-form-cookies-consent input:hover,
		.bwp-dark-style .bwp-content .wp-block-post-comments-form .comment-form-cookies-consent input:focus {
			border-color: ' . $dark_style_hover_color . ';
		}
		.bwp-dark-style input[type="checkbox"]:checked,
		.bwp-dark-style input[type="radio"]:checked {
			background: ' . $dark_style_hover_color . ';
			border-color: ' . $dark_style_hover_color . ';
		}
		.bwp-dark-style input[type="button"]:hover,
		.bwp-dark-style input[type="reset"]:hover,
		.bwp-dark-style input[type="submit"]:hover,
		.bwp-dark-style .bwp-homepage-slider-wrap .tns-controls button:hover,
		.bwp-dark-style .bwp-post-media-slider .tns-controls button:hover,
		.bwp-dark-style .bwp-content .wp-block-file a.wp-block-file__button:active,
		.bwp-dark-style .bwp-content .wp-block-file a.wp-block-file__button:focus,
		.bwp-dark-style .bwp-content .wp-block-file a.wp-block-file__button:hover,
		.bwp-dark-style .bwp-content .wp-block-search .wp-block-search__button:hover,
		.bwp-dark-style .bwp-content .wp-block-search .wp-block-search__button:focus,
		.bwp-dark-style .bwp-scroll-top-button:hover,
		.bwp-dark-style #bwp-accept-cookies:hover {
			background: ' . $dark_style_hover_color . ';
		}
		.bwp-dark-style .bwp-font-type.bwp-active,
		.bwp-dark-style .bwp-homepage-slider-zoom-image:hover,
		.bwp-dark-style .pagination .nav-links .page-numbers.current,
		.bwp-dark-style .bwp-single-post-tags a:hover,
		.bwp-dark-style .bwp-single-post-tags a:focus,
		.bwp-dark-style .bwp-content .bwp-single-post-pagination .post-page-numbers.current,
		.bwp-dark-style .bwp-comment-list .comment-body .reply a:hover,
		.bwp-dark-style .bwp-comment-list .pingback .comment-body .edit-link a:hover,
		.bwp-dark-style .bwp-comment-list .trackback .comment-body .edit-link a:hover,
		.bwp-dark-style .widget_bwp_social ul li a:hover,
		.bwp-dark-style .widget_bwp_social ul li a:focus,
		.bwp-dark-style .bwp-content .wp-block-query-pagination .page-numbers.current,
		.bwp-dark-style .bwp-content .wp-block-comments-pagination .page-numbers.current {
			background-color: ' . $dark_style_hover_color . ';
		}';
	}


	/**
	 * Customizer Section -> Other Theme Settings
	 * -------------------------------------------------------------
	 */

	// Cancel text transformation for some text elements (id: orin_cancel_text_transform)
	$cancel_text_transform = get_theme_mod( 'orin_cancel_text_transform', 0 ); // 1 or 0
	if ( $cancel_text_transform ) {
		$inline_styles .= '
		input[type="button"],
		input[type="reset"],
		input[type="submit"],
		.bwp-font-type,
		.bwp-section-header .bwp-category-tag-title,
		.comment-reply-title,
		.bwp-comments-title,
		.bwp-related-posts-title,
		.bwp-single-page-random-posts-title {
			text-transform: none;
		}';
	}


	/**
	 * Add inline styles (after the style.css file; id: orin-style)
	 * -------------------------------------------------------------
	 */
	wp_add_inline_style( 'orin-style', $inline_styles );

}
add_action( 'wp_enqueue_scripts', 'orin_inline_styles' );
