<?php
/**
 * The template for displaying 404 page
 *
 * @package WordPress
 * @subpackage Orin
 * @since Orin 1.0
 */

// header
get_header();
?>

<!-- content for page 404 -->
<main class="bwp-page-404-container">
	<div class="bwp-page-404-content">
		<h1><?php esc_html_e( 'Oops... Error 404', 'orin' ); ?></h1>
		<h2><?php esc_html_e( 'We are sorry, but the page you are looking for does not exist.', 'orin' ); ?></h2>
		<p><?php printf( __( 'Please check entered address and try again or go to <a href="%1$s" rel="home">homepage</a>.', 'orin' ), esc_url( home_url( '/' ) ) ); ?></p>
	</div>
</main>
<!-- end: content for page 404 -->

<?php
// footer
get_footer();
