<?php
/**
 * Slider with featured posts for the homepage
 *
 * @package WordPress
 * @subpackage Orin
 * @since Orin 1.0
 */

// show/hide slider
$show_homepage_slider = get_theme_mod( 'orin_show_homepage_slider', 0 ); // 1 or 0
if ( $show_homepage_slider ) {

	// slider options:
	// 1: maximum number of slides
	$homepage_slider_slides_max_number = get_theme_mod( 'orin_slider_slides_max_number', 4 );
	if ( '' === $homepage_slider_slides_max_number ) {
		$homepage_slider_slides_max_number = 4;
	}

	// 2: the type of posts for the slider
	$homepage_slider_shows_posts_from = get_theme_mod( 'orin_slider_shows_posts_from', 'posts-by-category' ); // 'posts-by-category' or 'featured-posts'

	// 3: category id
	$homepage_slider_category_id = get_theme_mod( 'orin_slider_category_id', 0 );
	if ( 0 === $homepage_slider_category_id ) {
		$homepage_slider_category_id = ''; // All categories
	}

	// 4: order by
	$homepage_slider_orderby = get_theme_mod( 'orin_slider_orderby', 'date' ); // 'rand', 'date', or 'comment_count'

	// 5: popup image: on or off
	$homepage_slider_popup_image = get_theme_mod( 'orin_slider_popup_image', 1 ); // 1 or 0

	// query arguments
	if ( 'posts-by-category' === $homepage_slider_shows_posts_from ) {
		// posts by category
		$homepage_slider_query_args = array(
			'post_type'				=> 'post',
			'posts_per_page'		=> intval( $homepage_slider_slides_max_number ),
			'cat'					=> $homepage_slider_category_id,
			'orderby'				=> $homepage_slider_orderby,
			'ignore_sticky_posts'	=> true,
		);
	} else {
		// featured posts (manually selected posts)
		$homepage_slider_query_args = array(
			'post_type'				=> 'post',
			'posts_per_page'		=> intval( $homepage_slider_slides_max_number ),
			'meta_key'				=> 'orin_mb_featured_post',
			'meta_value'			=> '1',
			'orderby'				=> $homepage_slider_orderby,
			'ignore_sticky_posts'	=> true,
		);
	}

	// start query
	$homepage_slider_query = new WP_Query( $homepage_slider_query_args );
	if ( $homepage_slider_query->have_posts() ) :
		// slider content: get display settings values
		$homepage_slider_show_author = get_theme_mod( 'orin_slider_show_author', 1 ); // 1 or 0
		$homepage_slider_show_date = get_theme_mod( 'orin_slider_show_date', 1 ); // 1 or 0
		$homepage_slider_show_categories = get_theme_mod( 'orin_slider_show_categories', 1 ); // 1 or 0
		$homepage_slider_show_read_more = get_theme_mod( 'orin_slider_show_read_more', 1 ); // 1 or 0
		// text for the "read more" link
		$homepage_slider_read_more_text = get_theme_mod( 'orin_slider_read_more_text', 'Read More' );
		?>

		<!-- section with slider -->
		<section class="bwp-homepage-slider-section bwp-site-section">

			<?php
			// title and subtitle
			$homepage_slider_header_title = get_theme_mod( 'orin_slider_section_title', '' );
			if ( '' !== $homepage_slider_header_title ) {
				$homepage_slider_header_subtitle = get_theme_mod( 'orin_slider_section_subtitle', '' );
				?>

				<!-- separator (with gradient) -->
				<div class="bwp-separator bwp-gradient"><span class="bwp-rhomb"></span></div>

				<!-- title and subtitle -->
				<header class="bwp-section-header">
					<h2 class="bwp-section-title">
						<?php
						echo wp_kses( $homepage_slider_header_title, array(
							'a'			=> array(
								'href'		=> array(),
								'title'		=> array(),
								'target'	=> array(),
								'class'		=> array(),
								'rel'		=> array(),
							),
							'span'		=> array(
								'class'		=> array(),
							),
							'strong'	=> array(),
							'b'			=> array(),
							'em'		=> array(),
							'i'			=> array(
								'class'		=> array(),
							),
						) );
						?>
					</h2>
					<?php
					if ( '' !== $homepage_slider_header_subtitle ) {
						?>
						<p>
							<?php
							echo wp_kses( $homepage_slider_header_subtitle, array(
								'a'			=> array(
									'href'		=> array(),
									'title'		=> array(),
									'target'	=> array(),
									'class'		=> array(),
									'rel'		=> array(),
								),
								'span'		=> array(
									'class'		=> array(),
								),
								'strong'	=> array(),
								'b'			=> array(),
								'em'		=> array(),
								'i'			=> array(
									'class'		=> array(),
								),
							) );
							?>
						</p>
						<?php
					}
					?>
					<div class="bwp-section-header-separator"></div>
				</header>
				<!-- end: title and subtitle -->

				<?php
			} else {
				?>

				<h2 class="screen-reader-text">
					<?php esc_html_e( 'Must-read articles', 'orin' ); ?>
				</h2>

				<?php
			}
			?>

			<!-- homepage slider -->
			<div class="bwp-homepage-slider-wrap<?php if ( $homepage_slider_popup_image ) { echo ' bwp-popup-gallery'; } ?>">
				<div id="bwp-homepage-slider">

					<?php
					while ( $homepage_slider_query->have_posts() ) :
						$homepage_slider_query->the_post();

						// post ID
						$homepage_slider_post_id = $post->ID;

						// background image
						$homepage_slider_image_id = get_post_meta( $homepage_slider_post_id, 'orin_mb_featured_post_image', true );
						if ( $homepage_slider_image_id ) {
							// image for slide
							$homepage_slider_image_url = wp_get_attachment_image_url( $homepage_slider_image_id, 'full' );
						} else {
							// featured image
							$homepage_slider_image_url = get_the_post_thumbnail_url( $homepage_slider_post_id, 'full' );
						}
						?>

						<!-- slide -->
						<div class="bwp-homepage-slider-item bwp-homepage-slider-post-<?php echo (int) $homepage_slider_post_id; if ( ! $homepage_slider_image_url ) { echo ' bwp-homepage-slider-item-no-bg'; } ?>">

							<?php
							if ( $homepage_slider_image_url ) {
								?>

								<!-- background image and dark overlay -->
								<div class="bwp-homepage-slider-item-bg" style="background-image: url(<?php echo esc_url( $homepage_slider_image_url ); ?>);"></div>
								<div class="bwp-homepage-slider-item-overlay"></div>
								<!-- end: background image and dark overlay -->

								<?php
								if ( $homepage_slider_popup_image ) {
									?>

									<!-- zoom button -->
									<a href="<?php echo esc_url( $homepage_slider_image_url ); ?>" class="bwp-popup-gallery-item bwp-homepage-slider-zoom-image" title="<?php echo esc_attr( get_the_title() ); ?>">
										<i class="fas fa-expand"></i>
									</a>
									<!-- end: zoom button -->

									<?php
								}
								?>

								<?php
							} else {
								?>

								<!-- background color (slide without image) -->
								<div class="bwp-homepage-slider-item-bg"></div>
								<!-- end: background color -->

								<?php
							}
							?>

							<!-- content -->
							<div class="bwp-homepage-slider-item-content">
								<div class="bwp-homepage-slider-content-alignment">
									<div class="bwp-homepage-slider-content-center">
										<div class="bwp-homepage-slider-content-container">
											<div class="bwp-homepage-slider-content-text">

												<?php
												// show metadata
												if ( $homepage_slider_show_author || $homepage_slider_show_date || $homepage_slider_show_categories ) {
													?>

													<!-- metadata (author, date, and categories) -->
													<ul class="bwp-homepage-slider-post-metadata list-unstyled">

														<?php
														// 1: author
														if ( $homepage_slider_show_author ) {
															// author data: id, name, and author posts url
															$author_id = get_the_author_meta( 'ID' );
															$author_display_name = get_the_author_meta( 'display_name' );
															$author_posts_url = get_author_posts_url( $author_id );
															?>

															<!-- author -->
															<li class="bwp-author">
																<a href="<?php echo esc_url( $author_posts_url ); ?>" rel="author">
																	<span class="vcard author">
																		<span class="fn"><?php echo esc_html( $author_display_name ); ?></span>
																	</span>
																</a>
															</li>
															<!-- end: author -->

															<?php
														}

														// 2: date
														if ( $homepage_slider_show_date ) {
															// year, month, day
															$time_year = get_the_time( 'Y' );
															$time_month = get_the_time( 'm' );
															$time_day = get_the_time( 'd' );
															?>

															<!-- date -->
															<li class="bwp-date">
																<a href="<?php echo esc_url( get_day_link( $time_year, $time_month, $time_day ) ); ?>">
																	<span class="date updated"><?php the_time( get_option( 'date_format' ) ); ?></span>
																</a>
															</li>
															<!-- end: date -->

															<?php
														}

														// 3: categories
														if ( $homepage_slider_show_categories ) {
															?>

															<!-- categories -->
															<li class="bwp-categories">
																<?php the_category( ', ' ); ?>
															</li>
															<!-- end: categories -->

															<?php
														}
														?>

													</ul>
													<!-- end: metadata -->

													<?php
												}
												?>

												<!-- title -->
												<?php if ( get_the_title() ) { ?>
													<h3 class="bwp-homepage-slider-post-title">
														<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
													</h3>
												<?php } else { ?>
													<h3 class="bwp-homepage-slider-post-title">
														<a href="<?php the_permalink(); ?>"><?php esc_html_e( 'No title', 'orin' ); ?></a>
													</h3>
												<?php } ?>
												<!-- end: title -->

												<?php
												// read more
												if ( $homepage_slider_show_read_more && '' !== $homepage_slider_read_more_text ) {
													?>
													<!-- read more -->
													<a href="<?php the_permalink(); ?>" class="bwp-homepage-slider-read-more"><?php echo esc_html( $homepage_slider_read_more_text ); ?><i class="fas fa-long-arrow-alt-right"></i></a>
													<!-- end: read more -->
													<?php
												}
												?>

											</div>
										</div>
									</div>
								</div>
							</div>
							<!-- end: content -->

						</div>
						<!-- end: slide -->

						<?php
					endwhile;
					?>

				</div>
				<div id="bwp-homepage-slider-loading-icon">
					<i class="fas fa-palette fa-spin"></i>
				</div>
			</div>
			<!-- end: homepage slider -->

		</section>
		<!-- end: section with slider -->

		<?php
	endif;

	// reset post data
	wp_reset_postdata();

}
