<?php
/**
 * Featured image / Slider (Appears in a post on all archive pages)
 *
 * @package WordPress
 * @subpackage Orin
 * @since Orin 1.0
 */

// post ID
$blog_post_id = $post->ID;

// thumbnail type
$gallery_thumb_type = get_post_meta( $blog_post_id, 'orin_mb_gallery_thumb_type', true ); // 'featured_image' or 'slider'
if ( ! $gallery_thumb_type ) {
	$gallery_thumb_type = 'slider'; // default value
}

// image size
$image_size = 'full';
$popup_image_size = 'full';

// image attributes
$image_attr = '';

// image size and image attributes depending on the page
if ( ! is_singular() ) {
	// archive pages; add new attributes
	$image_attr = array( 'loading' => 'eager' );
} else {
	// single pages; new size (900x600px)
	$image_size = 'orin-900-600-crop';
}

// link type
$link_type = get_theme_mod( 'orin_featured_image_link_type', 'link_to_post' ); // 'link_to_image' or 'link_to_post'

// thumbnail type = featured image
if ( 'featured_image' === $gallery_thumb_type ) {

	// if the post has a featured image
	if ( has_post_thumbnail() ) {
		?>

		<!-- featured image -->
		<figure class="bwp-post-media">

			<?php
			// link type: link to image
			if ( 'link_to_image' === $link_type ) {
				// image id
				$image_id = get_post_thumbnail_id();
				// data for popup image
				$popup_image_url = wp_get_attachment_image_url( $image_id, $popup_image_size );
				$popup_image_caption = get_post( $image_id )->post_excerpt;
				?>

				<a href="<?php echo esc_url( $popup_image_url ); ?>" class="bwp-popup-image" title="<?php if ( $popup_image_caption ) { echo esc_attr( $popup_image_caption ); } else { the_title_attribute(); } ?>">
					<?php the_post_thumbnail( $image_size, $image_attr ); ?>
					<div class="bwp-post-media-overlay"></div>
					<span class="bwp-post-hover-icon bwp-expand-image">
						<i class="fas fa-images"></i>
					</span>
				</a>

				<?php
			} else {
				// link type: link to post
				?>

				<a href="<?php the_permalink(); ?>">
					<?php the_post_thumbnail( $image_size, $image_attr ); ?>
					<div class="bwp-post-media-overlay"></div>
					<span class="bwp-post-hover-icon">
						<i class="fas fa-share"></i>
					</span>
				</a>

				<?php
			}
			?>

		</figure>
		<!-- end: featured image -->

		<?php
	}

} else {
	// thumbnail type = slider

	// slider: image IDs
	$gallery_images_id = get_post_meta( $blog_post_id, 'orin_mb_gallery', false );
	if ( ! is_array( $gallery_images_id ) ) {
		$gallery_images_id = (array) $gallery_images_id;
	}

	// if $gallery_images_id is not empty
	if ( ! empty( $gallery_images_id ) && $gallery_images_id[0] ) {

		// number of images
		$gallery_images_num = count( $gallery_images_id );
		if ( $gallery_images_num > 1 ) {
			// several images in the gallery; show slider
			?>

			<!-- slider with images -->
			<div class="bwp-post-media-slider<?php if ( 'link_to_image' === $link_type ) { echo ' bwp-popup-gallery'; } ?>">
				<div id="bwp-post-slider-<?php echo (int) $blog_post_id; ?>" class="bwp-post-slider">

					<?php
					foreach ( $gallery_images_id as $gallery_image_id ) {
						// image url and image alt
						$gallery_image_url = wp_get_attachment_image_url( $gallery_image_id, $image_size );
						$gallery_image_alt = get_post_meta( $gallery_image_id, '_wp_attachment_image_alt', true );
						?>

						<!-- slider item -->
						<figure class="bwp-post-slider-item">

							<?php
							// link type: link to image
							if ( 'link_to_image' === $link_type ) {
								// data for popup image
								$gallery_popup_image_url = wp_get_attachment_image_url( $gallery_image_id, $popup_image_size );
								$gallery_popup_image_caption = get_post( $gallery_image_id )->post_excerpt;
								?>

								<a href="<?php echo esc_url( $gallery_popup_image_url ); ?>" class="bwp-popup-gallery-item" title="<?php if ( $gallery_popup_image_caption ) { echo esc_attr( $gallery_popup_image_caption ); } else { the_title_attribute(); } ?>">
									<img src="<?php echo esc_url( $gallery_image_url ); ?>" alt="<?php if ( $gallery_image_alt ) { echo esc_attr( $gallery_image_alt ); } else { the_title_attribute(); } ?>" loading="eager">
									<div class="bwp-post-media-overlay"></div>
									<span class="bwp-post-hover-icon bwp-expand-image">
										<i class="fas fa-images"></i>
									</span>
								</a>

								<?php
							} else {
								// link type: link to post
								?>

								<a href="<?php the_permalink(); ?>">
									<img src="<?php echo esc_url( $gallery_image_url ); ?>" alt="<?php if ( $gallery_image_alt ) { echo esc_attr( $gallery_image_alt ); } else { the_title_attribute(); } ?>" loading="eager">
									<div class="bwp-post-media-overlay"></div>
									<span class="bwp-post-hover-icon">
										<i class="fas fa-share"></i>
									</span>
								</a>

								<?php
							}
							?>

						</figure>
						<!-- end: slider item -->

						<?php
					}
					?>

				</div>
			</div>
			<!-- end: slider with images -->

			<?php
		} else {
			// one image in the gallery; show only this image
			// image url and image alt
			$gallery_image_url = wp_get_attachment_image_url( $gallery_images_id[0], $image_size );
			$gallery_image_alt = get_post_meta( $gallery_images_id[0], '_wp_attachment_image_alt', true );
			?>

			<!-- single gallery image -->
			<figure class="bwp-post-media">

				<?php
				// link type: link to image
				if ( 'link_to_image' === $link_type ) {
					// data for popup image
					$gallery_popup_image_url = wp_get_attachment_image_url( $gallery_images_id[0], $popup_image_size );
					$gallery_popup_image_caption = get_post( $gallery_images_id[0] )->post_excerpt;
					?>

					<a href="<?php echo esc_url( $gallery_popup_image_url ); ?>" class="bwp-popup-image" title="<?php if ( $gallery_popup_image_caption ) { echo esc_attr( $gallery_popup_image_caption ); } else { the_title_attribute(); } ?>">
						<img src="<?php echo esc_url( $gallery_image_url ); ?>" alt="<?php if ( $gallery_image_alt ) { echo esc_attr( $gallery_image_alt ); } else { the_title_attribute(); } ?>" loading="eager">
						<div class="bwp-post-media-overlay"></div>
						<span class="bwp-post-hover-icon bwp-expand-image">
							<i class="fas fa-images"></i>
						</span>
					</a>

					<?php
				} else {
					// link type: link to post
					?>

					<a href="<?php the_permalink(); ?>">
						<img src="<?php echo esc_url( $gallery_image_url ); ?>" alt="<?php if ( $gallery_image_alt ) { echo esc_attr( $gallery_image_alt ); } else { the_title_attribute(); } ?>" loading="eager">
						<div class="bwp-post-media-overlay"></div>
						<span class="bwp-post-hover-icon">
							<i class="fas fa-share"></i>
						</span>
					</a>

					<?php
				}
				?>

			</figure>
			<!-- end: single gallery image -->

			<?php
		}

	}

}
