<?php
/**
 * The template for displaying the header
 *
 * @package WordPress
 * @subpackage Orin
 * @since Orin 1.0
 */
?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

	<link rel="profile" href="https://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<!-- header -->
<header id="bwp-header">
	<div class="container">
		<div class="bwp-header-container clearfix">

			<?php
			// main menu (theme_location: orin_main_menu)
			if ( has_nav_menu( 'orin_main_menu' ) ) {
				?>

				<!-- menu -->
				<div class="bwp-header-menu">
					<?php
					// show main menu
					wp_nav_menu( array(
						'theme_location'	=> 'orin_main_menu',
						'container'			=> 'nav',
						'menu_class'		=> 'sf-menu',
					) );
					?>
				</div>
				<!-- end: menu -->

				<!-- mobile menu -->
				<div class="bwp-header-mobile-menu">
					<!-- button: show/hide mobile menu -->
					<button type="button" id="bwp-toggle-mobile-menu" class="bwp-button">
						<i class="fas fa-bars"></i><span class="bwp-button-text"><?php esc_html_e( 'Menu', 'orin' ); ?></span>
					</button>
					<!-- end: button -->
					<!-- container with menu (hidden) -->
					<div id="bwp-dropdown-mobile-menu" class="bwp-hidden">
						<?php
						// show mobile menu
						wp_nav_menu( array(
							'theme_location'	=> 'orin_main_menu',
							'container'			=> 'nav',
							'menu_class'		=> 'bwp-mobile-menu list-unstyled',
						) );
						?>
					</div>
					<!-- end: container with menu -->
				</div>
				<!-- end: mobile menu -->

				<?php
			}

			// sidebar button: show or hide
			$show_sidebar_button = is_active_sidebar( 'orin_sidebar' ) && get_theme_mod( 'orin_show_sidebar_button', 1 ); // true or false
			// search: show or hide
			$show_search = get_theme_mod( 'orin_show_search', 1 ); // 1 or 0
			// color switch: show or hide
			$show_color_switch = get_theme_mod( 'orin_enable_color_switch', 0 ); // 1 or 0
			// font types: show or hide
			$show_font_types = get_theme_mod( 'orin_enable_font_switch', 0 ); // 1 or 0

			if ( $show_sidebar_button || $show_search || $show_color_switch || $show_font_types ) {
				?>

				<!-- header icons -->
				<div class="bwp-header-icons clearfix<?php if ( ! $show_sidebar_button ) { echo ' bwp-no-sidebar-button'; } ?>">

					<?php
					// sidebar button
					if ( $show_sidebar_button ) {
						?>

						<!-- button: show sidebar -->
						<button type="button" id="bwp-show-sidebar" class="bwp-button bwp-header-sidebar-button">
							<i class="fas fa-arrow-left"></i>
						</button>
						<!-- end: button -->

						<?php
					}

					// search
					if ( $show_search ) {
						?>

						<!-- search (search icon and search form) -->
						<div class="bwp-header-search">
							<!-- search icon -->
							<button type="button" id="bwp-toggle-dropdown-search" class="bwp-button">
								<i class="fas fa-search"></i>
							</button>
							<!-- end: search icon -->
							<!-- container with search form (hidden) -->
							<div id="bwp-dropdown-search" class="bwp-hidden">
								<?php
								// show search form
								get_search_form();
								?>
							</div>
							<!-- end: container with search form -->
						</div>
						<!-- end: search -->

						<?php
					}

					// color switch
					if ( $show_color_switch ) {
						// get current theme style
						$current_theme_style = orin_get_current_theme_style();
						?>

						<!-- button: change color scheme (light or dark) -->
						<button type="button" id="bwp-toggle-color" class="bwp-button">
							<?php if ( 'light' === $current_theme_style ) { ?>
								<i class="fas fa-moon"></i>
							<?php } else { ?>
								<i class="fas fa-sun"></i>
							<?php } ?>
						</button>
						<!-- end: button -->

						<?php
					}

					// font types
					if ( $show_font_types ) {
						// current font type
						$current_font_type = orin_get_current_font_type();
						?>

						<!-- font types (sans-serif or serif) -->
						<div class="bwp-font-types">
							<!-- font icon -->
							<button type="button" id="bwp-show-font-types" class="bwp-button">
								<i class="fas fa-font"></i>
							</button>
							<!-- end: font icon -->
							<!-- container with available font types (hidden) -->
							<div id="bwp-dropdown-font-types" class="bwp-hidden">
								<div class="bwp-font-type<?php if ( 'sans-serif' === $current_font_type ) { echo ' bwp-active'; } ?>" data-font-type="sans-serif">
									<?php esc_html_e( 'Sans-serif fonts', 'orin' ); ?>
								</div>
								<div class="bwp-font-type<?php if ( 'serif' === $current_font_type ) { echo ' bwp-active'; } ?>" data-font-type="serif">
									<?php esc_html_e( 'Serif fonts', 'orin' ); ?>
								</div>
							</div>
							<!-- end: container with available font types -->
						</div>
						<!-- end: font types -->

						<?php
					}
					?>

				</div>
				<!-- end: header icons -->

				<?php
			}
			?>

		</div>
	</div>
</header>
<!-- end: header -->

<!-- container with site content -->
<div class="bwp-site-content">
	<div class="container">

		<!-- logo area -->
		<div class="bwp-logo-container clearfix">
			<?php
			// show logo (image or text)
			orin_show_custom_logo();

			// site name (h1)
			if ( ! is_singular() && ! is_404() ) {
				$hidden_site_name = get_bloginfo( 'name' );
				?>
				<!-- site name -->
				<h1 class="screen-reader-text bwp-site-name"><?php echo esc_html( $hidden_site_name ); ?></h1>
				<!-- end: site name -->
				<?php
			}
			?>
		</div>
		<!-- end: logo area -->
