<?php
/**
 * The template for displaying posts in the Video post format
 *
 * @package WordPress
 * @subpackage Orin
 * @since Orin 1.0
 */

// post ID
$blog_post_id = $post->ID;

// post with password or not
$is_password_protected = post_password_required();
?>

<!-- post (video format) -->
<article id="bwp-post-<?php echo (int) $blog_post_id; ?>" <?php post_class(); ?>>
	<div class="bwp-post-wrap">

		<?php
		// featured image or video player (iframe)
		if ( ! $is_password_protected ) {
			get_template_part( 'templates/blog-post-media/media', 'video' );
		}
		?>

		<!-- content -->
		<div class="bwp-post-content">

			<?php
			// sticky post: icon
			if ( is_sticky() ) {
				?>

				<!-- sticky post - icon -->
				<div class="bwp-post-sticky-mark">
					<i class="fas fa-thumbtack"></i>
				</div>
				<!-- end: sticky post - icon -->

				<?php
			}

			// metadata
			orin_show_post_metadata();

			// post content (title and excerpt)
			orin_show_post_content();

			// read more and counters
			orin_show_post_links( 'post', $is_password_protected );
			?>

		</div>
		<!-- end: content -->

	</div>
</article>
<!-- end: post (video format) -->
