<?php
/**
 * Widget: Social Links
 *
 * @since Orin Additional Features 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Register widget
 */
add_action( 'widgets_init', 'orin_additional_features_register_social_widget' );

function orin_additional_features_register_social_widget() {
	register_widget( 'orin_additional_features_social_widget' );
}


/**
 * Class orin_additional_features_social_widget
 */
class orin_additional_features_social_widget extends WP_Widget {

	/**
	 * Sets up the widget name, description, class, etc
	 */
	public function __construct() {
		$widget_ops = array(
			'classname'		=> 'widget_bwp_social',
			'description'	=> esc_html__( 'Displays links to social profiles.', 'orin-additional-features' ),
		);
		parent::__construct( 'orin_social_widget', esc_html__( 'Orin: Social Links', 'orin-additional-features' ), $widget_ops );
	}

	/**
	 * Outputs the options form on admin
	 */
	public function form( $instance ) {
		// defaults
		$title_instance = isset( $instance['title'] ) ? sanitize_text_field( $instance['title'] ) : '';
		$twitter_url_instance = isset( $instance['twitter_url'] ) ? sanitize_text_field( $instance['twitter_url'] ) : '';
		$facebook_url_instance = isset( $instance['facebook_url'] ) ? sanitize_text_field( $instance['facebook_url'] ) : '';
		$pinterest_url_instance = isset( $instance['pinterest_url'] ) ? sanitize_text_field( $instance['pinterest_url'] ) : '';
		$telegram_url_instance = isset( $instance['telegram_url'] ) ? sanitize_text_field( $instance['telegram_url'] ) : '';
		$reddit_url_instance = isset( $instance['reddit_url'] ) ? sanitize_text_field( $instance['reddit_url'] ) : '';
		$vk_url_instance = isset( $instance['vk_url'] ) ? sanitize_text_field( $instance['vk_url'] ) : '';
		$linkedin_url_instance = isset( $instance['linkedin_url'] ) ? sanitize_text_field( $instance['linkedin_url'] ) : '';
		$flickr_url_instance = isset( $instance['flickr_url'] ) ? sanitize_text_field( $instance['flickr_url'] ) : '';
		$instagram_url_instance = isset( $instance['instagram_url'] ) ? sanitize_text_field( $instance['instagram_url'] ) : '';
		$youtube_url_instance = isset( $instance['youtube_url'] ) ? sanitize_text_field( $instance['youtube_url'] ) : '';
		$vimeo_url_instance = isset( $instance['vimeo_url'] ) ? sanitize_text_field( $instance['vimeo_url'] ) : '';
		$soundcloud_url_instance = isset( $instance['soundcloud_url'] ) ? sanitize_text_field( $instance['soundcloud_url'] ) : '';
		$dribbble_url_instance = isset( $instance['dribbble_url'] ) ? sanitize_text_field( $instance['dribbble_url'] ) : '';
		$behance_url_instance = isset( $instance['behance_url'] ) ? sanitize_text_field( $instance['behance_url'] ) : '';
		$github_url_instance = isset( $instance['github_url'] ) ? sanitize_text_field( $instance['github_url'] ) : '';
		$stack_overflow_url_instance = isset( $instance['stack_overflow_url'] ) ? sanitize_text_field( $instance['stack_overflow_url'] ) : '';
		$slack_url_instance = isset( $instance['slack_url'] ) ? sanitize_text_field( $instance['slack_url'] ) : '';
		$rss_url_instance = isset( $instance['rss_url'] ) ? sanitize_text_field( $instance['rss_url'] ) : '';
		?>

		<!-- title -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $title_instance ); ?>">
		</p>
		<!-- end: title -->

		<!-- twitter -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'twitter_url' ) ); ?>"><?php esc_html_e( 'Twitter URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'twitter_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'twitter_url' ) ); ?>" value="<?php echo esc_attr( $twitter_url_instance ); ?>">
		</p>
		<!-- end: twitter -->

		<!-- facebook -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'facebook_url' ) ); ?>"><?php esc_html_e( 'Facebook URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'facebook_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'facebook_url' ) ); ?>" value="<?php echo esc_attr( $facebook_url_instance ); ?>">
		</p>
		<!-- end: facebook -->

		<!-- pinterest -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'pinterest_url' ) ); ?>"><?php esc_html_e( 'Pinterest URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'pinterest_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'pinterest_url' ) ); ?>" value="<?php echo esc_attr( $pinterest_url_instance ); ?>">
		</p>
		<!-- end: pinterest -->

		<!-- telegram -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'telegram_url' ) ); ?>"><?php esc_html_e( 'Telegram URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'telegram_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'telegram_url' ) ); ?>" value="<?php echo esc_attr( $telegram_url_instance ); ?>">
		</p>
		<!-- end: telegram -->

		<!-- reddit -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'reddit_url' ) ); ?>"><?php esc_html_e( 'Reddit URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'reddit_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'reddit_url' ) ); ?>" value="<?php echo esc_attr( $reddit_url_instance ); ?>">
		</p>
		<!-- end: reddit -->

		<!-- vk -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'vk_url' ) ); ?>"><?php esc_html_e( 'VK URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'vk_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'vk_url' ) ); ?>" value="<?php echo esc_attr( $vk_url_instance ); ?>">
		</p>
		<!-- end: vk -->

		<!-- linkedin -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'linkedin_url' ) ); ?>"><?php esc_html_e( 'Linkedin URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'linkedin_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'linkedin_url' ) ); ?>" value="<?php echo esc_attr( $linkedin_url_instance ); ?>">
		</p>
		<!-- end: linkedin -->

		<!-- flickr -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'flickr_url' ) ); ?>"><?php esc_html_e( 'Flickr URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'flickr_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'flickr_url' ) ); ?>" value="<?php echo esc_attr( $flickr_url_instance ); ?>">
		</p>
		<!-- end: flickr -->

		<!-- instagram -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'instagram_url' ) ); ?>"><?php esc_html_e( 'Instagram URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'instagram_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'instagram_url' ) ); ?>" value="<?php echo esc_attr( $instagram_url_instance ); ?>">
		</p>
		<!-- end: instagram -->

		<!-- YouTube -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'youtube_url' ) ); ?>"><?php esc_html_e( 'YouTube URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'youtube_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'youtube_url' ) ); ?>" value="<?php echo esc_attr( $youtube_url_instance ); ?>">
		</p>
		<!-- end: YouTube -->

		<!-- vimeo -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'vimeo_url' ) ); ?>"><?php esc_html_e( 'Vimeo URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'vimeo_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'vimeo_url' ) ); ?>" value="<?php echo esc_attr( $vimeo_url_instance ); ?>">
		</p>
		<!-- end: vimeo -->

		<!-- soundcloud -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'soundcloud_url' ) ); ?>"><?php esc_html_e( 'Soundcloud URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'soundcloud_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'soundcloud_url' ) ); ?>" value="<?php echo esc_attr( $soundcloud_url_instance ); ?>">
		</p>
		<!-- end: soundcloud -->

		<!-- dribbble -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'dribbble_url' ) ); ?>"><?php esc_html_e( 'Dribbble URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'dribbble_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'dribbble_url' ) ); ?>" value="<?php echo esc_attr( $dribbble_url_instance ); ?>">
		</p>
		<!-- end: dribbble -->

		<!-- behance -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'behance_url' ) ); ?>"><?php esc_html_e( 'Behance URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'behance_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'behance_url' ) ); ?>" value="<?php echo esc_attr( $behance_url_instance ); ?>">
		</p>
		<!-- end: behance -->

		<!-- github -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'github_url' ) ); ?>"><?php esc_html_e( 'Github URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'github_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'github_url' ) ); ?>" value="<?php echo esc_attr( $github_url_instance ); ?>">
		</p>
		<!-- end: github -->

		<!-- stack overflow -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'stack_overflow_url' ) ); ?>"><?php esc_html_e( 'Stack Overflow URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'stack_overflow_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'stack_overflow_url' ) ); ?>" value="<?php echo esc_attr( $stack_overflow_url_instance ); ?>">
		</p>
		<!-- end: stack overflow -->

		<!-- slack -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'slack_url' ) ); ?>"><?php esc_html_e( 'Slack URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'slack_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'slack_url' ) ); ?>" value="<?php echo esc_attr( $slack_url_instance ); ?>">
		</p>
		<!-- end: slack -->

		<!-- rss -->
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'rss_url' ) ); ?>"><?php esc_html_e( 'RSS URL:', 'orin-additional-features' ); ?></label>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'rss_url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'rss_url' ) ); ?>" value="<?php echo esc_attr( $rss_url_instance ); ?>">
		</p>
		<!-- end: rss -->

		<?php
	}

	/**
	 * Processing widget options on save
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['twitter_url'] = sanitize_text_field( $new_instance['twitter_url'] );
		$instance['facebook_url'] = sanitize_text_field( $new_instance['facebook_url'] );
		$instance['pinterest_url'] = sanitize_text_field( $new_instance['pinterest_url'] );
		$instance['telegram_url'] = sanitize_text_field( $new_instance['telegram_url'] );
		$instance['reddit_url'] = sanitize_text_field( $new_instance['reddit_url'] );
		$instance['vk_url'] = sanitize_text_field( $new_instance['vk_url'] );
		$instance['linkedin_url'] = sanitize_text_field( $new_instance['linkedin_url'] );
		$instance['flickr_url'] = sanitize_text_field( $new_instance['flickr_url'] );
		$instance['instagram_url'] = sanitize_text_field( $new_instance['instagram_url'] );
		$instance['youtube_url'] = sanitize_text_field( $new_instance['youtube_url'] );
		$instance['vimeo_url'] = sanitize_text_field( $new_instance['vimeo_url'] );
		$instance['soundcloud_url'] = sanitize_text_field( $new_instance['soundcloud_url'] );
		$instance['dribbble_url'] = sanitize_text_field( $new_instance['dribbble_url'] );
		$instance['behance_url'] = sanitize_text_field( $new_instance['behance_url'] );
		$instance['github_url'] = sanitize_text_field( $new_instance['github_url'] );
		$instance['stack_overflow_url'] = sanitize_text_field( $new_instance['stack_overflow_url'] );
		$instance['slack_url'] = sanitize_text_field( $new_instance['slack_url'] );
		$instance['rss_url'] = sanitize_text_field( $new_instance['rss_url'] );

		return $instance;
	}

	/**
	 * Outputs the content of the widget
	 */
	public function widget( $args, $instance ) {
		$title = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( 'Social links', 'orin-additional-features' );

		// get all URLs
		$social_url = array();
		$social_url['twitter'] = ! empty( $instance['twitter_url'] ) ? $instance['twitter_url'] : '';
		$social_url['facebook-f'] = ! empty( $instance['facebook_url'] ) ? $instance['facebook_url'] : '';
		$social_url['pinterest-p'] = ! empty( $instance['pinterest_url'] ) ? $instance['pinterest_url'] : '';
		$social_url['telegram-plane'] = ! empty( $instance['telegram_url'] ) ? $instance['telegram_url'] : '';
		$social_url['reddit-alien'] = ! empty( $instance['reddit_url'] ) ? $instance['reddit_url'] : '';
		$social_url['vk'] = ! empty( $instance['vk_url'] ) ? $instance['vk_url'] : '';
		$social_url['linkedin-in'] = ! empty( $instance['linkedin_url'] ) ? $instance['linkedin_url'] : '';
		$social_url['flickr'] = ! empty( $instance['flickr_url'] ) ? $instance['flickr_url'] : '';
		$social_url['instagram'] = ! empty( $instance['instagram_url'] ) ? $instance['instagram_url'] : '';
		$social_url['youtube'] = ! empty( $instance['youtube_url'] ) ? $instance['youtube_url'] : '';
		$social_url['vimeo-v'] = ! empty( $instance['vimeo_url'] ) ? $instance['vimeo_url'] : '';
		$social_url['soundcloud'] = ! empty( $instance['soundcloud_url'] ) ? $instance['soundcloud_url'] : '';
		$social_url['dribbble'] = ! empty( $instance['dribbble_url'] ) ? $instance['dribbble_url'] : '';
		$social_url['behance'] = ! empty( $instance['behance_url'] ) ? $instance['behance_url'] : '';
		$social_url['github'] = ! empty( $instance['github_url'] ) ? $instance['github_url'] : '';
		$social_url['stack-overflow'] = ! empty( $instance['stack_overflow_url'] ) ? $instance['stack_overflow_url'] : '';
		$social_url['slack'] = ! empty( $instance['slack_url'] ) ? $instance['slack_url'] : '';
		$social_url['rss'] = ! empty( $instance['rss_url'] ) ? $instance['rss_url'] : '';

		// display "div" tag (before widget)
		echo wp_kses( $args['before_widget'], array(
			'div'	=> array(
				'id'	=> array(),
				'class'	=> array(),
			),
		) );

		// display widget title
		if ( $title ) {
			echo wp_kses( $args['before_title'], array(
				'h3'	=> array(
					'class'	=> array(),
				),
			) );
			echo esc_html( $title );
			echo wp_kses( $args['after_title'], array( 'h3' => array() ) );
		}

		// check $social_url
		$social_url_empty = true;
		foreach ( $social_url as $social_url_value ) {
			if ( $social_url_value ) {
				$social_url_empty = false;
				break;
			}
		}

		// show social links
		if ( ! $social_url_empty ) {
			?>
			<ul class="list-unstyled clearfix">
				<?php
				foreach ( $social_url as $social_url_key => $social_url_value ) {
					if ( $social_url_value ) {
						if ( 'rss' !== $social_url_key ) {
							?>
							<li>
								<a href="<?php echo esc_url( $social_url_value ); ?>" target="_blank" rel="noopener noreferrer" class="widget_bwp_social_link widget_bwp_social_link_<?php echo esc_attr( $social_url_key ); ?>">
									<i class="fab fa-<?php echo esc_attr( $social_url_key ); ?>"></i>
								</a>
							</li>
							<?php
						} else {
							?>
							<li>
								<a href="<?php echo esc_url( $social_url_value ); ?>" target="_blank" rel="noopener noreferrer" class="widget_bwp_social_link widget_bwp_social_link_rss">
									<i class="fas fa-rss"></i>
								</a>
							</li>
							<?php
						}
					}
				}
				?>
			</ul>
			<?php
		} else {
			?>
			<p class="widget_bwp_no_social_links">
				<?php esc_html_e( 'There are no social links.', 'orin-additional-features' ); ?>
			</p>
			<?php
		}

		// display "div" tag (after widget)
		echo wp_kses( $args['after_widget'], array( 'div' => array() ) );
	}

}
