<?php
/**
 * Social share buttons (Twitter, Facebook, and Reddit)
 *
 * @since Orin Additional Features 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * The function displays social share buttons on single pages
 *
 * @since Orin Additional Features 1.0
 */
function orin_additional_features_show_share_buttons() {

	// post data: url and title
	$share_url = get_permalink();
	$share_title = get_the_title();
	?>

	<!-- social share buttons -->
	<div class="bwp-single-post-share">
		<ul class="bwp-single-post-share-list list-unstyled">
			<!-- twitter -->
			<li>
				<a href="https://twitter.com/share?url=<?php echo esc_url( $share_url ); ?>&text=<?php echo rawurlencode( $share_title ); ?>" rel="nofollow noopener" target="_blank" class="bwp-twitter-share bwp-tooltip" onclick="window.open('https://twitter.com/share?url=<?php echo esc_url( $share_url ); ?>&text=<?php echo rawurlencode( $share_title ); ?>', 'Twitter', 'width=700,height=500,left='+(screen.availWidth/2-350)+',top='+(screen.availHeight/2-250)+''); return false;" data-toggle="tooltip" data-placement="top" title="<?php esc_attr_e( 'Share on Twitter', 'orin-additional-features' ); ?>">
					<i class="fab fa-twitter"></i>
				</a>
			</li>
			<!-- end: twitter -->
			<!-- facebook -->
			<li>
				<a href="https://www.facebook.com/sharer.php?u=<?php echo esc_url( $share_url ); ?>&t=<?php echo rawurlencode( $share_title ); ?>" rel="nofollow noopener" target="_blank" class="bwp-facebook-share bwp-tooltip" onclick="window.open('https://www.facebook.com/sharer.php?u=<?php echo esc_url( $share_url ); ?>&t=<?php echo rawurlencode( $share_title ); ?>', 'Facebook', 'width=700,height=500,left='+(screen.availWidth/2-350)+',top='+(screen.availHeight/2-250)+''); return false;" data-toggle="tooltip" data-placement="top" title="<?php esc_attr_e( 'Share on Facebook', 'orin-additional-features' ); ?>">
					<i class="fab fa-facebook-f"></i>
				</a>
			</li>
			<!-- end: facebook -->
			<!-- reddit -->
			<li>
				<a href="https://www.reddit.com/submit?url=<?php echo esc_url( $share_url ); ?>&title=<?php echo rawurlencode( $share_title ); ?>" rel="nofollow noopener" target="_blank" class="bwp-reddit-share bwp-tooltip" onclick="window.open('https://www.reddit.com/submit?url=<?php echo esc_url( $share_url ); ?>&title=<?php echo rawurlencode( $share_title ); ?>', 'Reddit', 'width=800,height=700,left='+(screen.availWidth/2-400)+',top='+(screen.availHeight/2-350)+''); return false;" data-toggle="tooltip" data-placement="top" title="<?php esc_attr_e( 'Share on Reddit', 'orin-additional-features' ); ?>">
					<i class="fab fa-reddit-alien"></i>
				</a>
			</li>
			<!-- end: reddit -->
		</ul>
	</div>
	<!-- end: social share buttons -->

	<?php
}
