<?php
/*
Plugin Name: Orin Additional Features
Plugin URI: http://birdwp.com/
Description: This plugin provides a set of additional features for the Orin theme. This set includes the following features: 5 additional widgets, views counter, comments counter, social share buttons (Twitter, Facebook, and Reddit), and a notification with information about cookies on the site.
Version: 1.0
Requires at least: 5.7
Requires PHP: 5.6
Author: Alexey Trofimov (BirdwpThemes)
Author URI: https://themeforest.net/user/birdwpthemes
License: GNU General Public License v2 or later
License URI: http://www.gnu.org/licenses/gpl-2.0.html
Text Domain: orin-additional-features
Domain Path: /languages

Copyright (C) 2021 Alexey Trofimov
Orin Additional Features is distributed under the terms of the GNU GPL
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Define some constants
 *
 * @since Orin Additional Features 1.0
 */
define( 'ORIN_ADDITIONAL_FEATURES_DIR', plugin_dir_path( __FILE__ ) );
define( 'ORIN_ADDITIONAL_FEATURES_URL', plugin_dir_url( __FILE__ ) );


/**
 * Make plugin available for translation
 *
 * @since Orin Additional Features 1.0
 */
function orin_additional_features_load_language_file() {

	// load language file; text domain = "orin-additional-features"
	load_plugin_textdomain( 'orin-additional-features', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );

}
add_action( 'plugins_loaded', 'orin_additional_features_load_language_file' );


/**
 * Enqueue scripts
 *
 * @since Orin Additional Features 1.0
 */
function orin_additional_features_scripts() {

	// orin additional features: main script file
	wp_enqueue_script( 'orin-additional-features-plugin', ORIN_ADDITIONAL_FEATURES_URL . 'js/orin-additional-features-plugin.js', array( 'jquery' ), '1.0.0', true );

	// add some data to the main script file:

	// cookies notice: show or hide
	$show_cookies_notice = get_theme_mod( 'orin_show_cookies_notice', 0 ); // 1 or 0
	$cookiesNotice_data = ( $show_cookies_notice ) ? 'show' : 'hide';

	// cookies notice: type of notification on mobile devices
	$cookiesNoticeOnMobile_data = get_theme_mod( 'orin_cookies_notice_on_mobile', 'hidden' ); // 'hidden' or 'visible'

	// array with data
	$orinAdditionalFeaturesData_array = array(
		'cookiesNotice'			=> $cookiesNotice_data,
		'cookiesNoticeOnMobile'	=> $cookiesNoticeOnMobile_data,
	);
	// add data
	wp_localize_script( 'orin-additional-features-plugin', 'orinAdditionalFeaturesData', $orinAdditionalFeaturesData_array );

}
add_action( 'wp_enqueue_scripts', 'orin_additional_features_scripts' );


/**
 * Counters: Views and comments
 *
 * @since Orin Additional Features 1.0
 */
require_once ORIN_ADDITIONAL_FEATURES_DIR . 'counters/comments-counter.php';
require_once ORIN_ADDITIONAL_FEATURES_DIR . 'counters/views-counter.php';


/**
 * Social share buttons (Twitter, Facebook, and Reddit)
 *
 * @since Orin Additional Features 1.0
 */
require_once ORIN_ADDITIONAL_FEATURES_DIR . 'social-share-buttons/social-share-buttons.php';


/**
 * Add new widgets
 *
 * @since Orin Additional Features 1.0
 */
require_once ORIN_ADDITIONAL_FEATURES_DIR . 'widgets/widget-list-of-posts.php';
require_once ORIN_ADDITIONAL_FEATURES_DIR . 'widgets/widget-popular-posts.php';
require_once ORIN_ADDITIONAL_FEATURES_DIR . 'widgets/widget-random-posts.php';
require_once ORIN_ADDITIONAL_FEATURES_DIR . 'widgets/widget-recent-posts.php';
require_once ORIN_ADDITIONAL_FEATURES_DIR . 'widgets/widget-social-links.php';


/**
 * Cookies notice
 *
 * @since Orin Additional Features 1.0
 */
require_once ORIN_ADDITIONAL_FEATURES_DIR . 'cookies-notice/cookies-notice.php';
