/**
 * Plugin name: Orin Additional Features
 * orin-additional-features-plugin.js v1.0
 */

( function( $ ) {
	'use strict';
	$( document ).ready( function() {

		var $cookiesInfoContainer = $( '#bwp-cookies-info' ),
			cookiesAccepted = 'orin_cookies_accepted'; // cookie name; this cookie is used to store the status of the "Cookies information" window: "Yes", if the "Accept" button was pressed, otherwise "No"


		/**
		 * Information about cookies: Hide the notification after accepting the cookie agreement
		 * ----------------------------------------------------
		 */
		function acceptCookies() {

			var $acceptCookiesButton = $( '#bwp-accept-cookies' );

			// click on the button
			$acceptCookiesButton.on( 'click', function() {

				// hide information about cookies
				$cookiesInfoContainer.addClass( 'bwp-cookies-accepted' );
				setTimeout( function() {
					$cookiesInfoContainer.css( 'display', 'none' );
				}, 350 );

				// set cookie (we must remember that the user agrees to accept cookies)
				setCookie( cookiesAccepted, 'yes' );

			} );

		}

		acceptCookies();

		// if the notification is hidden by the user, then delete the cookie of this notification
		if ( 'hide' === orinAdditionalFeaturesData.cookiesNotice ) {
			if ( getCookie( cookiesAccepted ) ) {
				deleteCookie( cookiesAccepted );
			}
		}


		/**
		 * Information about cookies for mobile devices (notification type: hidden)
		 * ----------------------------------------------------
		 */
		function showHideCookiesInfoMobile() {

			var $showCookiesInfo = $( '#bwp-show-cookies-info' ),
				$hideCookiesInfo = $( '#bwp-hide-cookies-info' ),
				hiddenCssClass = 'bwp-hidden',
				visibleCssClass = 'bwp-visible';

			// show information about cookies
			$showCookiesInfo.on( 'click', function() {
				if ( $cookiesInfoContainer.hasClass( hiddenCssClass ) ) {
					$showCookiesInfo.addClass( hiddenCssClass );
					$cookiesInfoContainer.removeClass( hiddenCssClass ).addClass( visibleCssClass );
				}
			} );

			// hide information about cookies
			$hideCookiesInfo.on( 'click', function() {
				if ( $cookiesInfoContainer.hasClass( visibleCssClass ) ) {
					$cookiesInfoContainer.removeClass( visibleCssClass ).addClass( hiddenCssClass );
					setTimeout( function() {
						$showCookiesInfo.removeClass( hiddenCssClass );
					}, 200 );
				}
			} );

		}

		if ( 'hidden' === orinAdditionalFeaturesData.cookiesNoticeOnMobile ) {
			showHideCookiesInfoMobile();
		}


		/**
		 * Cookie: set cookie, get cookie, and delete cookie
		 * ----------------------------------------------------
		 */

		// function: set cookie
		function setCookie( name, value ) {

			// cookie value
			value = encodeURIComponent( value );

			// expiration date (+60 days)
			var date = new Date;
			date.setDate( date.getDate() + 60 );

			// set cookie
			document.cookie = name + '=' + value + '; path=/; expires=' + date.toUTCString();

		}

		// function: get cookie
		function getCookie( name ) {

			var matches = document.cookie.match( new RegExp(
				"(?:^|; )" + name.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1') + "=([^;]*)"
			) );

			return matches ? decodeURIComponent( matches[1] ) : undefined;

		}

		// function: delete cookie
		function deleteCookie( name ) {

			// set the date in the past
			var date = new Date;
			date.setDate( date.getDate() - 1 );

			// delete cookie
			document.cookie = name + '=; path=/; expires=' + date.toUTCString();

		}

	} );
} )( jQuery );
