﻿#!/bin/bash
cert_root="certyfikat.crt"
cert_root_name="NASK PIB"
data="$(date +%Y%m%d_%H%M)"
logfile="$(hostname)_${data}.log"
linia="...................................................................................................."

### Log data+hostname+user+kernel
echo "${linia}" >> ${logfile}
echo "${data}" >> ${logfile}
echo $(hostname) >> ${logfile}
echo $(whoami) >> ${logfile}
echo $(uname -r) >> ${logfile}
echo "${linia}" >> ${logfile}

### Komunikat dla uzytkownika
echo .....................................................
echo Skrypt dla systemow operacyjnych Linux \(dystrybucja Ubuntu i Debian\)
echo Wymaga uruchomienia z uprawnieniami Administratora
echo Skrypt zostal uruchomiony na komputerze $(hostname)
echo Aktualna data ${data}
echo .....................................................

### Instalacja narzedzia certutil
echo Trwa instalacja narzedzi, moze to potrwac kilka minut...
sudo apt install libnss3-tools -y >> ${logfile}
echo "${linia}" >> ${logfile}
echo Zainstalowano narzedzie certutil

### Wprowadzenie certyfikatu do bazy danych certyfikatow systemowych
sudo cp ${cert_root} /usr/local/share/ca-certificates/${cert_root}
sudo update-ca-certificates >> ${logfile}
echo "${linia}" >> ${logfile}
echo Dodano Certyfikaty systemowe


### Wprowadzenie certyfikatu do baz danych uzywanych przez przegladarki internetowe
echo "Sciezki cert8" >> ${logfile}
for cDB in $(sudo find /home/ -name "cert8.db")
do
	cert_dir=$(dirname ${cDB});
	echo "${cert_dir}" >> ${logfile}
	sudo certutil -A -n "${cert_root_name}" -t "C" -i ${cert_root} -d dbm:${cert_dir} >> ${logfile}
done
for cDB in $(sudo find ~/ -name "cert8.db")
do
	cert_dir=$(dirname ${cDB});
	echo "${cert_dir}" >> ${logfile}
	sudo certutil -A -n "${cert_root_name}" -t "C" -i ${cert_root} -d dbm:${cert_dir} >> ${logfile}
done
echo "Sciezki cert9" >> ${logfile}
for cDB in $(sudo find /home/ -name "cert9.db")
do
	cert_dir=$(dirname ${cDB});
	echo "${cert_dir}" >> ${logfile}
	sudo certutil -A -n "${cert_root_name}" -t "C" -i ${cert_root} -d sql:${cert_dir} >> ${logfile}
done
for cDB in $(sudo find ~/ -name "cert9.db")
do
	cert_dir=$(dirname ${cDB});
	echo "${cert_dir}" >> ${logfile}
	sudo certutil -A -n "${cert_root_name}" -t "C" -i ${cert_root} -d sql:${cert_dir} >> ${logfile}
done
echo Dodano Certyfikaty w bazach zainstalowanych przegladarek uzytkownikom obecnie zarejestrowanych na danej stacji
